/***********************************************************************

   rdemo - reads a rasterfile, computes the average of the colour
   values (if applicable) of the pixels, and writes a new rasterfile
   with the average.  An inverting colour map is added.

***********************************************************************/

#include <stdio.h>
#include "rast.h"

main(argc,argv)
int argc;
char *argv[];
{
	int r, g, b, avg, row, col, i, pix, ifile, ofile;
	RASTER *irast, *orast, *Ropen(), *Rdopen();

	ifile = 0;
	ofile = 0;

	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				case 'i': ifile = ++i; break;
				case 'o': ofile = ++i; break;
				default:  usage();
			}
		}
	}

	if (ifile) irast = Ropen(argv[ifile],R);
	else irast = Rdopen(0,R);
	if (irast == NULL) {
		fprintf(stderr,"rdemo: input rasterfile open failed!\n");
		exit(1);
	}

	if (ofile) orast = Ropen(argv[ofile],W);
	else orast = Rdopen(1,W);
	if (irast == NULL) {
		fprintf(stderr,"rdemo: output rasterfile open failed!\n");
		exit(1);
	}

	if (!Rgetheader(irast)) {
		fprintf(stderr,"input file is not a raster file!\n");
		exit(1);
	}

	orast->height = irast->height;
	orast->width  = irast->width;
	orast->depth  = irast->depth;

	Rinitmap(orast,RMT_EQUAL_RGB,256*3);
	for (i = 0; i < 256; i++) Rputmap(orast,255-i,i,i,i);
	
	Rputheader(orast);

	if (irast->maptype == RMT_EQUAL_RGB) {
		for (row = 0; row < irast->height; row++) 
			for (col = 0; col < irast->width; col++) {
				Rgetmappedpix(irast,&r,&g,&b);
				avg = (r + g + b) / 3;
				Rputpix(orast,avg);
			}
	}
	else if (irast->maptype == RMT_RAW) {
		for (row = 0; row < irast->height; row++) 
			for (col = 0; col < irast->width; col++) {
				Rgetmappedpix(irast,&pix);
				Rputpix(orast,pix);
			}
	}
	else if (irast->maptype == RMT_NONE) {
		for (row = 0; row < irast->height; row++) 
			for (col = 0; col < irast->width; col++) {
				pix = Rgetpix(irast);
				Rputpix(orast,pix);
			}
	}
	else {
		fprintf(stderr,"rdemo: unknown map type in input rasterfile!\n");
		exit(1);
	}
	
	Rclose(irast);
	Rclose(orast);
}

usage()
{
	fprintf(stderr,"usage: rdemo [-i file] [-o file]\n");
	fprintf(stderr,"       -i  input rasterfile [default is stdin]\n");
	fprintf(stderr,"       -o  output rasterfile [default is stdout]\n");
	exit(0);
}
