#include <stdio.h>
#include <pixrect/pixrect_hs.h>

#define R 0
#define W 1

typedef struct RASTER_STRUCT {
	int height;				/* number of rows							*/
	int width;				/* number of columns						*/
	int depth;				/* bits per pixel							*/
	int length;				/* bytes of data following header			*/
	int type;				/* rasterfile type							*/
	int maptype;			/* type of lookup table						*/
	int maplength;			/* length of lookup table					*/
	char *map;				/* lookup table								*/
	int linelen;			/* bytes in a row (padded to even 16 bits)	*/
	FILE *fp;				/* file pointer								*/
	int mode;				/* read (R) or write (W) mode flag			*/
	char *cache;			/* cache of 1 row							*/
	int c_pixel;			/* current pixel in row cache				*/
	struct pixrect *c_pr;	/* make cache look like a pixrect			*/
} RASTER;
