#include "rast.h"

RASTER *Ropen(f,m)
char *f;
int m;
{
	RASTER *im, *Ropen_read(), *Ropen_write();

	im = NULL;
	if (m == R) im = Ropen_read(f);
	if (m == W) im = Ropen_write(f);
	return(im);
}

RASTER *Rdopen(f,m)
int f,m;
{
	RASTER *im, *Rdopen_stdin(), *Rdopen_stdout();

	im = NULL;
	if (f == 0 && m == R) im = Rdopen_stdin();
	if (f == 1 && m == W) im = Rdopen_stdout();
	return(im);
}

RASTER *Ropen_read(f)
char *f;
{
	RASTER *im;
	char *malloc();

	im = (RASTER *)malloc(sizeof(RASTER));
	im->fp = fopen(f,"r");
	im->mode = R;
	if (im->fp == NULL) {
		fprintf(stderr,"read open fails for file \"%s\"!\n",f);
		im = NULL;
		return(im);
	}
	return(im);
}

RASTER *Rdopen_stdin()
{
	RASTER *im;
	char *malloc();

	im = (RASTER *)malloc(sizeof(RASTER));
	im->fp = stdin;
	im->mode = R;
	if (im->fp == NULL) {
		fprintf(stderr,"read open fails for stdin!\n");
		im = NULL;
		return(im);
	}
	return(im);
}

RASTER *Ropen_write(f)
char *f;
{
	RASTER *im;
	char *malloc();

	im = (RASTER *)malloc(sizeof(RASTER));
	im->fp = fopen(f,"w");
	if (im->fp == NULL) {
		fprintf(stderr,"write open fails for file \"%s\"!\n",f);
		im = NULL;
		return(im);
	}

	im->mode      = W;
	im->width     = 0;
	im->height    = 0;
	im->depth     = 0;
	im->maplength = 0;
	im->maptype   = RMT_NONE;

	if (im->fp == NULL) im = NULL;
	return(im);
}

RASTER *Rdopen_stdout()
{
	RASTER *im;
	char *malloc();

	im = (RASTER *)malloc(sizeof(RASTER));
	im->fp = stdout;
	if (im->fp == NULL) {
		fprintf(stderr,"write open fails for stdout!\n");
		im = NULL;
		return(im);
	}

	im->mode      = W;
	im->width     = 0;
	im->height    = 0;
	im->depth     = 0;
	im->maplength = 0;
	im->maptype   = RMT_NONE;

	return(im);
}

Rgetheader(im)
RASTER *im;
{
	char *malloc();
	int i, rc, ll, extra;
	struct rasterfile rhead;

	rc = fread(&rhead,(sizeof (struct rasterfile)),1,im->fp);
	
	if (rc <= 0) {
		fprintf(stderr,"Rgetheader failed!\n");
		return(0);
	}
	if (rhead.ras_magic != RAS_MAGIC) return(0);

	im->height    = rhead.ras_height;
	im->width     = rhead.ras_width;
	im->depth     = rhead.ras_depth;
	im->length    = rhead.ras_length;
	im->type      = rhead.ras_type;
	im->maptype   = rhead.ras_maptype;
	im->maplength = rhead.ras_maplength;

	extra = (16 - ((im->width * im->depth) % 16)) % 16;
	ll = ((im->width * im->depth) + extra) / 8;

	im->linelen   = ll;
	im->cache     = malloc(ll);
	im->c_pixel   = im->width + 1;
	im->c_pr      = mem_point(im->width,1,im->depth,im->cache);
	if (im->maplength > 0) {
		im->map = malloc(im->maplength);
		for (i = 0; i < im->maplength; i++) im->map[i] = getc(im->fp);
	}
	return(1);
}

Rputheader(im)
RASTER *im;
{
	char *malloc();
	int i, rc, ll, extra;
	struct rasterfile rhead;

	extra = (16 - ((im->width * im->depth) % 16)) % 16;
	ll = ((im->width * im->depth) + extra) / 8;

	if (im->width == 0) {
		fprintf(stderr,"rasterfile width is zero!\n");
		return(0);
	}
	if (im->height == 0) {
		fprintf(stderr,"rasterfile height is zero!\n");
		return(0);
	}
	if (im->depth == 0) {
		fprintf(stderr,"rasterfile depth is zero!\n");
		return(0);
	}

	rhead.ras_magic     = RAS_MAGIC;
	rhead.ras_width     = im->width;
	rhead.ras_height    = im->height;
	rhead.ras_depth     = im->depth;
	rhead.ras_length    = ll * im->height;
	rhead.ras_type      = RT_STANDARD;
	rhead.ras_maptype   = im->maptype;
	rhead.ras_maplength = im->maplength;

	im->linelen   = ll;
	im->cache     = malloc(ll);
	im->c_pixel   = 0;
	im->c_pr      = mem_point(im->width,1,im->depth,im->cache);

	rc = fwrite(&rhead,(sizeof (struct rasterfile)),1,im->fp);
	
	if (rc <= 0) {
		fprintf(stderr,"Rputheader failed!\n");
		return(0);
	}

	if (im->maptype != RMT_NONE && im->maplength > 0)
		fwrite(im->map,im->maplength,1,im->fp);
	return(1);
}

Rgetpix(im)
RASTER *im;
{
	int pix;
	
	if (im->mode != R) {
		fprintf(stderr,"attempt to read rasterfile opened for write!\n");
		return(-1);
	}

	if (im->c_pixel >= im->width) {
		fread(im->cache,im->linelen,1,im->fp);
		im->c_pixel = 0;
	}

	pix = pr_get(im->c_pr,im->c_pixel,0);
	im->c_pixel++;
	return(pix);
}

Rputpix(im,pix)
RASTER *im;
int pix;
{
	if (im->mode != W) {
		fprintf(stderr,"attempt to write rasterfile opened for read!\n");
		return(-1);
	}

	pr_put(im->c_pr,im->c_pixel,0,pix);
	im->c_pixel++;
	
	if (im->c_pixel >= im->width) {
		fwrite(im->cache,im->linelen,1,im->fp);
		im->c_pixel = 0;
	}
}

Rclose(im)
RASTER *im;
{
	if (im->mode == W) fflush(im->fp);
	fclose(im->fp);
}

Rinfo(im)
RASTER *im;
{
	fprintf(stderr,"  height    = %d\n",im->height);
	fprintf(stderr,"  width     = %d\n",im->width);
	fprintf(stderr,"  depth     = %d\n",im->depth);
	fprintf(stderr,"  length    = %d\n",im->length);
	fprintf(stderr,"  type      = %d\n",im->type);
	fprintf(stderr,"  maptype   = %d\n",im->maptype);
	fprintf(stderr,"  maplength = %d\n",im->maplength);
}

Rinitmap(im,t,l)
RASTER *im;
int t,l;
{
	char *malloc();

	im->maptype   = t;
	im->maplength = l;
	im->map       = malloc(l);
}

Rputmap(im,i,r,g,b)
RASTER *im;
int i,r,g,b;
{
	int x;
	
	switch (im->maptype) {
		case RMT_NONE: 
			fprintf(stderr,"can't put in a null map!\n");
			break;
		case RMT_RAW:
			im->map[i] = r;
			break;
		case RMT_EQUAL_RGB:
			x = i * 3;
			im->map[x++] = r;
			im->map[x++] = g;
			im->map[x]   = b;
			break;
		default:
			fprintf(stderr,"unknown map type in rasterfile!\n");
	}
}

Rgetmap(im,i,r,g,b)
RASTER *im;
int i,*r,*g,*b;
{
	int x;
	
	switch (im->maptype) {
		case RMT_NONE: 
			fprintf(stderr,"can't get from a null map!\n");
			break;
		case RMT_RAW:
			*r = im->map[i];
			break;
		case RMT_EQUAL_RGB:
			x = i * 3;
			*r = im->map[x++];
			*g = im->map[x++];
			*b = im->map[x];
			break;
		default:
			fprintf(stderr,"unknown map type in rasterfile!\n");
	}
}

Rgetmappedpix(im,r,g,b)
RASTER *im;
int *r,*g,*b;
{
	int pix, x;

	if (im->mode != R) {
		fprintf(stderr,"attempt to read rasterfile opened for write!\n");
		return(-1);
	}
	
	if (im->c_pixel >= im->width) {
		fread(im->cache,im->linelen,1,im->fp);
		im->c_pixel = 0;
	}

	pix = pr_get(im->c_pr,im->c_pixel,0);
	im->c_pixel++;
	
	switch (im->maptype) {
		case RMT_RAW: 
			*r = im->map[pix];
			break;
		case RMT_EQUAL_RGB:
			x = pix * 3;
			*r = im->map[x++];
			*g = im->map[x++];
			*b = im->map[x];
			break;
		default:
			*r = pix;
			break;
	}
}
