/* Compile: cc -g -o scload scload.c -lpixrect */

/**************************************************************************
   The program "scload" is like Sun's "screenload" program, but more
   entertaining, and actually better than screenload.

   Copyright (c) 1988 by Raymond Kreisel
   7/1/88 @ Suny Stony Brook

   This program may be redistributed without fee as long as this copyright
   notice is intact.

==> PLEASE send comments and bug reports to one of the following addresses:

	   Ray Kreisel
	   CS Dept., SUNY at Stony Brook, Stony Brook NY 11794

	   UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
	   ARPA-Internet: rayk@sbcs.sunysb.edu			
	   CSnet: rayk@suny-sb
	   (If nobody is home at any of the above addresses try:
		S72QKRE@TOWSONVX.BITNET			        )

 "If I get home before daylight, I just might get some sleep tonight...."

**************************************************************************/
#include <pixrect/pixrect_hs.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>


int time_rand()
{
 struct tm *localtime(), *nowtime;
 long inttime;

 inttime = time();
 nowtime = localtime(&inttime);
 return((int)((nowtime->tm_sec)));
}


main(argc,argv) int argc; char *argv[];
{
int i, my_fb = 0;
char *fb, *strcpy();

   if (argc == 1) {
       fprintf(stderr,"Usage: scload [-f frame_buffer] filename\n");
	exit(1);
   }

   if ((argv[1][0] == '-') && (argv[1][1] == 'f')) {
	if (argc < 4) {
           fprintf(stderr,"Usage: scload [-f frame_buffer] filename\n");
	   exit(1);
	}
	fb = strcpy((char *)malloc(strlen(argv[2])+1), argv[2]);
	my_fb = 1;
   }
   else fb = strcpy((char *)malloc(8), "/dev/fb");
   if (argc)
   {
   for(i=1+my_fb*2;i<argc;i++)
     new_sc_load(argv[i], fb);
   }
   else
     new_sc_load("", fb);
}


new_sc_load(filename, fb)
char *filename, *fb;
{
  char colormapname[256];
  struct rasterfile rh;
  colormap_t colormap;
  FILE *fp,*fopen();
  int	i, j,width,height,off_x,off_y;
  struct pixrect	*line, *screen, *screen_temp;
  int sleep_time=500;

	srand(time_rand());
	if (filename[0])
	{
  	  fp = fopen(filename,"r");
  	  if (!fp)
  	  {
  	    fprintf(stderr,"error open file %s for read\n", filename);
  	    return;
  	  }
	}
	else
	  fp = stdin;

	screen = pr_open(fb);
	if (!screen)
	   exit(1);

    if (screen->pr_depth > 1)
    {
      sleep_time = 0;
      if (pr_load_header(fp,&rh)) {
        perror("scload: pr_load_header");
        exit(-1);
        };
      if (pr_load_colormap(fp,&rh,&colormap)) {
        perror("scload: pr_load_colormap");
        exit(-1);
        };
      if (!(screen_temp=pr_load_image(fp,&rh,&colormap))) {
         perror("scload: pr_load_image");
         exit(-1);
         };
      if (colormap.length)
        pr_putcolormap(screen,0,rh.ras_maplength/3,colormap.map[0],
                     colormap.map[1],colormap.map[2]);
  
    }
    else
    {
        screen_temp = pr_load(fp,NULL);
        if (!screen_temp)
        {
            fprintf(stderr,"Error reading rasterfile header.\n");
            exit(0);
        }
    }
	width = screen_temp->pr_size.x;
	height = screen_temp->pr_size.y;
	if (screen->pr_size.x > screen_temp->pr_size.x)
	   off_x = (screen->pr_size.x - screen_temp->pr_size.x)/2;
	if (screen->pr_size.y > screen_temp->pr_size.y)
	   off_y = (screen->pr_size.y - screen_temp->pr_size.y)/2;

	switch(rand()%8) {  
	case 0:
		for (j=height-16; j > 0; j-=16)
		{
		   pr_rop(screen,off_x,j+off_y,width,height-j,PIX_SRC,screen_temp,0,0);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		
		break;
	case 1:

		for (j=0; j < height; j+=32)
		   for (i=0; i < width; i+=32)
		      pr_rop(screen,i+off_x,j+off_y,16,16,PIX_SRC,screen_temp,i,j);
		for (j=16; j < height; j+=32)
		   for (i=16; i < width; i+=32)
		      pr_rop(screen,i+off_x,j+off_y,16,16,PIX_SRC,screen_temp,i,j);
		for (j=16; j < height; j+=32)
		   for (i=0; i < width; i+=32)
		      pr_rop(screen,i+off_x,j+off_y,16,16,PIX_SRC,screen_temp,i,j);
		for (j=0; j < height; j+=32)
		   for (i=16; i < width; i+=32)
		      pr_rop(screen,i+off_x,j+off_y,16,16,PIX_SRC,screen_temp,i,j);
		break;

	case 2:
		for (j=height-16; j > 0; j-=16)
		{
	   
		   pr_rop(screen,off_x,off_y,width,height-j,PIX_SRC,screen_temp,0,j);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		break;

	case 3:
		for (j=height-16; j > 0; j-=16)
		{
	   
		   pr_rop(screen,off_x,j+off_y,width/2,height-j,PIX_SRC,screen_temp,0,0);
		   pr_rop(screen,off_x+width/2,off_y,width/2,height-j,PIX_SRC,screen_temp,width/2,j);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		break;
	case 4:
		for (j=height-16; j > 0; j-=16)
		{
	   
		   pr_rop(screen,off_x+width/2,j+off_y,width/2,height-j,PIX_SRC,screen_temp,width/2,0);
		   pr_rop(screen,off_x,off_y,width/2,height-j,PIX_SRC,screen_temp,0,j);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		break;

	case 5:
		for (j=height-16; j > 0; j-=16)
		{
	   
		   pr_rop(screen,off_x,off_y,width/4,height-j,PIX_SRC,screen_temp,0,j);
		   pr_rop(screen,off_x+width/4,j+off_y,width/4+2,height-j,PIX_SRC,screen_temp,width/4,0);
		   pr_rop(screen,off_x+width/4*3,j+off_y,width/4,height-j,PIX_SRC,screen_temp,width/4*3,0);
		   pr_rop(screen,off_x+width/2,off_y,width/4,height-j,PIX_SRC,screen_temp,width/2,j);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		break;
	case 6:
		for (j=height-16; j > 0; j-=16)
		{
	   
		   pr_rop(screen,off_x,off_y,width/4,height-j,PIX_SRC,screen_temp,0,j);
		   pr_rop(screen,off_x+width/4,j+off_y,width/4,height-j,PIX_SRC,screen_temp,width/4,0);
		   pr_rop(screen,off_x+width/2,j+off_y,width/4,height-j,PIX_SRC,screen_temp,width/2,0);
		   pr_rop(screen,off_x+width/4*3,off_y,width/4,height-j,PIX_SRC,screen_temp,width/4*3,j);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		break;

	case 7:
		for (j=16; j < width/2; j+=16)
		{
	   
		   pr_rop(screen,off_x+width/2-j,off_y,j,height,PIX_SRC,screen_temp,0,0);
		   pr_rop(screen,off_x+width/2,off_y,j,height,PIX_SRC,screen_temp,width-j,0);
		   usleep(sleep_time);
		}
		pr_rop(screen,off_x,off_y,width,height,PIX_SRC,screen_temp,0,0);
		break;
	}

	pr_destroy(screen_temp);
	pr_close(screen);
        fclose(fp);
}

