/*
 * input.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: input.c,v 3.0 89/10/27 02:05:51 craig Exp $
 *
 * $Log:	input.c,v $
 * Revision 3.0  89/10/27  02:05:51  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#ifdef SYSV
#include <string.h>
#else
#ifndef AZTEC_C
#include <strings.h>
#else /* AZTEC_C */

getpid()
{
	return 123;
}
#endif
#endif
#include "constants.h"
#include "typedefs.h"

#define INCLUDE_STR	"#include "

char *infilename;	/* Name of input file.  NULL signifies stdin. */
char tmpname[BUFSIZ];	/* name of temporary file */
extern FILE *yyin;	/* lex/yacc file pointer */

read_input_file()
{
	extern char *infilename;

	/*
	 * Open temporary file.
	 */
	sprintf(tmpname,"%s/raytmp.%d",TMPDIR, getpid());
	yyin = fopen(tmpname, "w");

	if (yyin == (FILE *)NULL) {
		fprintf(stderr,"Cannot write to temp file %s\n",tmpname);
		exit(1);
	}

	if (!process_file(infilename)) {
		/*
		 * Some kind of error occurred -- unlink
		 * temporary file and exit.
		 */
		fclose(yyin);
		unlink(tmpname);
		exit(1);
	}
	/*
	 * File processed okay.  Close the file, open it again for
	 * reading, and call lex/yacc.
	 */
	fclose(yyin);
	yyin = fopen(tmpname, "r");
	yyparse();
	/*
	 * All done -- unlink temporary file.
	 */
	unlink(tmpname);
}

/*
 * Open the named file and copy its contents into the temporary file.
 * If we run across a #include directive, recurse on the desired
 * file.  Note that *no checking is performed* -- a file could,
 * for example, include itself.  Rayshade will happily go on
 * copying data into the temporary file until it runs out
 * of file pointers (an fopen will fail), or you run out of disk space...
 */
process_file(filename)
char *filename;
{
	FILE *fp;
	char buf[BUFSIZ], *name, *np;
	extern int yylineno;

	if (filename == (char *)NULL)
		fp = stdin;
	else {
		fp = fopen(filename, "r");
		if (fp == (FILE *)NULL) {
			fprintf(stderr,"Cannot open %s for reading.\n",filename);
			return FALSE;
		}
	}

	while(fgets(buf, BUFSIZ, fp) != NULL) {
		if (strncmp(buf, INCLUDE_STR, strlen(INCLUDE_STR)) == 0) {
			/*
			 * Got an "#include "...
			 */
#ifdef SYSV
			name = strchr(buf, '"');
			np = strrchr(buf, '"');
#else
			name = index(buf, '"');
			np = rindex(buf, '"');
#endif
			/*
			 * Get name between quotes.  If no or
			 * one quote, complain.
			 */
			if (name == (char *)0 || name == np) {
				fprintf(stderr,"Invalid include directive (line %d)\n", yylineno);
				return FALSE;
			}
			name++;
			*np = (char)NULL;
			if (process_file(name) == FALSE)
				return FALSE;
		} else
			fputs(buf, yyin);
	}
	return TRUE;
}
