/*
 * memory.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: memory.c,v 3.0 89/10/27 02:05:56 craig Exp $
 *
 * $Log:	memory.c,v $
 * Revision 3.0  89/10/27  02:05:56  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include "typedefs.h"
#include "funcdefs.h"

unsigned long TotalAllocated;

char *
Malloc(bytes)
unsigned bytes;
{
	char *res, *malloc();

	TotalAllocated += bytes;

	res = malloc(bytes);
	if (res == (char *)0) {
		fprintf(stderr,"Out of memory trying to allocate %d bytes.\n");
		exit(0);
	}
	return res;
}

char *
Calloc(nelem, elen)
unsigned nelem, elen;
{
	char *res;

	res = Malloc(nelem*elen);
#ifdef SYSV
	memset(res, (char)0, nelem*elen);
#else
	bzero(res, nelem*elen);
#endif
	return res;
}

PrintMemoryStats()
{
	extern FILE *fstats;

	fprintf(fstats,"Total memory allocated:\t\t%d bytes\n",TotalAllocated);
}
