/* input_yacc.y								    */
/*									    */
/* Copyright (C) 1989, Craig E. Kolb					    */
/*									    */
/* This software may be freely copied, modified, and redistributed,	    */
/* provided that this copyright notice is preserved on all copies.	    */
/* 									    */
/* There is no warranty or other guarantee of fitness for this software,    */
/* it is provided solely "as is".  Bug reports or fixes may be sent	    */
/* to the author, who may or may not act on them as he desires.		    */
/*									    */
/* You may not include this software in a program or other software product */
/* without supplying the source, or without informing the end-user that the */
/* source is available for no extra charge.				    */
/*									    */
/* If you modify this software, you should include a notice giving the	    */
/* name of the person performing the modification, the date of modification,*/
/* and the reason for such modification.				    */
/*									    */
/* $Id: input_yacc.y,v 3.0 89/10/27 02:05:53 craig Exp $ */
%{
#include <stdio.h>
#include "constants.h"
#include "typedefs.h"
#include "funcdefs.h"
#include "texture.h"

int Npoints=0, CurXSize, CurYSize, CurZSize;
Object *LastObj = (Object *)0;
ObjList *CurObj, *ListTmp;
Surface *stmp;
Texture *CurText;
TransInfo *CurTrans = (TransInfo *)0, CurITrans;
PointList *Polypoints, *Point;
extern FILE *yyin;
extern Object *World;
extern int WorldXSize, WorldYSize, WorldZSize, nlight, Xres, Yres, maxlevel;
extern int yylineno, Jittered, JitSamples, pixel_div;
extern double hfov, vfov, RedContrast, GreenContrast, BlueContrast;
extern double TreeCutoff;
extern Vector eyep, lookp, up;
extern char outfilename[];
extern Color background;
extern SurfaceList *Surfaces;
extern Light light[];
extern Fog *GlobalFog;
extern Mist *GlobalMist;
%}
%union {
	char *c;
	int i;
	double d;
	Vector v;
	Color col;
	struct Texture *text;
}
%token <i> tINT
%token <d> tFLOAT
%token <c> tSTRING
%token tADAPTIVE tBACKGROUND tBLOTCH tBOX tBUMP tCONE tCYL tDIRECTIONAL
%token tENDDEF tEXTENDED tEYEP tFBM tFBMBUMP tFOG tFOV tGRID
%token tHEIGHTFIELD tJITTERED tLIGHT tLIST tLOOKP tMARBLE tMAXDEPTH tMIST
%token tOBJECT tOUTFILE
%token tPLANE tPOINT tPOLY tROTATE tSAMPLES
%token tSCALE tSCREEN tSPHERE tSTARTDEF tSUPERQ tSURFACE tRESOLUTION
%token tTHRESH tTRANSLATE tTRANSFORM tTRIANGLE tUP tENDFILE
%token tTEXTURE tCHECKER tWOOD tCONTRAST tCUTOFF
%type <d> Fnumber
%type <c> String
%type <v> Vector
%type <col> Color
%type <text> Texturetype
%%
Items		: /* empty */
		| Items Item
		;
Item		: Eyep
		| Lookp
		| Up
		| Fov
		| Screen
		| Maxdepth
		| Samples
		| Jittered
		| Adaptive
		| Contrast
		| Cutoff
		| Background
		| Light
		| Primitive
		| Child
		| Surface
		| Outfile
		| List
		| Grid
		| Object
		| Fog
		| Mist
		| tENDFILE		/* For backward compatibility */
		;
List		: tLIST
		{
			if (CurObj->data)
				CurObj->data->type = LIST;
			else
				World->type = LIST;
		}
		;
Grid		: tGRID tINT tINT tINT
		{
			if (CurObj->data) {
				CurObj->data->type = GRID;
				CurXSize = $2;
				CurYSize = $3;
				CurZSize = $4;
			} else {
				World->type = GRID;
				WorldXSize = $2;
				WorldYSize = $3;
				WorldZSize = $4;
			}
		}
		;
Primitive	: Prim Textures
		{
			if (LastObj)
				/* User may have botched prim. def. */
				LastObj->texture = CurText;
			CurText = (Texture *)0;
			LastObj = (Object *)0;
		}
		;
Prim		: Primtype Transforms
		{
			if (LastObj != (Object *)0) {
				/*
				 * Compute boundings box of primitive.
				 * if box's low X is > its high X,
				 * then the prim is unbounded.
				 */
				set_prim_bounds(LastObj);
				/*
				 * Add primitive to current object
				 * list.  When the obj. def. is complete
				 * make_list() will calculate the
				 * bounding box of the entire object.
				 */
				add_prim(LastObj, CurObj->data);
				if (CurTrans) {
					/*
					 * Compute the bounding box of the
					 * transformed object.
					 */
					transform_bounds(CurTrans,
							LastObj->bounds);
					invert_trans(&CurITrans, CurTrans);
					LastObj->trans = new_trans(CurTrans,
								&CurITrans);
					free((char *)CurTrans);
					CurTrans = (TransInfo *)0;
				}
			} else {
				/*
				 * There was something wrong with the def.
				 */
				if (CurTrans) {
					free((char *)CurTrans);
					CurTrans = (TransInfo *)0;
				}
			}
		}
		;
Primtype	: Plane
		| Sphere
		| Box
		| Triangle
		| Cylinder
		| Cone
		| Superq
		| Poly
		| HeightField
		;
Object		: Objectdef Textures
		{
			CurObj->data->texture = CurText;
			CurText = (Texture *)0;
			free((char *)CurObj);
			CurObj = CurObj->next;
		}
		;
Objectdef	: Startdef Objdefs tENDDEF
		{
			/*
			 * Object definition.
			 */
			LastObj = (Object *)NULL;
			if (CurObj->data->data == (char *)0) {
				fprintf(stderr,"Warning: null object defined");
				fprintf(stderr," (line %d)\n",yylineno);
			} else {
				if (CurObj->data->type == GRID) {
					list2grid(CurObj->data, CurXSize,
						CurYSize, CurZSize);
				} else {
					/*
				 	 * Object is a list -- transform the
				 	 * linked list (ObjList) into a List.
				 	 */
					make_list(CurObj->data);
				}
				/*
			 	 * Add this new object to the list of
			 	 * defined objects.
			 	 */
				add_to_objects(CurObj->data);
			}
		}
		;
Startdef	: tSTARTDEF String
		/*
		 * define <name>
		 */
		{
			/*
			 * Once we know the bounding box of this object
			 * (and the user hasn't specified that this object
			 * is stored in a List), then we enlist everything
			 * it contains.
			 * The new object's DATA field points to an ObjList
			 * until the definition complete, when the ObjList
			 * is then turned into either a Grid or a List.
			 */
			ListTmp = (ObjList *)Malloc(sizeof(ObjList));
			ListTmp->data = new_object($2, LIST, (char *)NULL,
						(Trans *)NULL);
			ListTmp->next = CurObj;
			CurObj = ListTmp;
		}
		;
Objdefs		: Objdefs Objdef
		|
		;
Objdef		: Primitive
		| Surface
		| Child
		| List
		| Grid
		| Object
		;
Textures	: Textures Texture
		|
		;
Texture		: tTEXTURE Texturetype Transforms
		{
			/*
			 * Set transformation information.
			 */
			if (CurTrans) {
				invert_trans(&CurITrans, CurTrans);
				$2->trans = new_trans(CurTrans,&CurITrans);
				free((char *)CurTrans);
				CurTrans = (TransInfo *)NULL;
			}
			/*
			 * Walk to the end of list of textures and
			 * append new texture.  This is done so that
			 * textures are implied in the expected order.
			 */
			{
				Texture *tp;

				$2->next = (Texture *)0;

				if (CurText) {
					for (tp=CurText;tp->next;tp=tp->next)
							;
					tp->next = $2;

				} else {
					CurText = $2;
				}
			}
		}
		;
Texturetype	: tCHECKER String
		{
			$$ = NewCheckText($2);
		}
		| tBLOTCH Fnumber String
		{
			$$ = NewBlotchText($2, $3);
		}
		| tBUMP Fnumber
		{
			$$ = NewBumpText($2);
		}
		| tMARBLE
		{
			$$ = NewMarbleText((char *)NULL);
		}
		| tMARBLE String
		{
			$$ = NewMarbleText($2);
		}
		| tFBM Fnumber Fnumber Fnumber Fnumber tINT Fnumber
		{
			$$ = NewfBmText($2, $3, $4, $5, $6, $7, (char *)0);
		}
		| tFBM Fnumber Fnumber Fnumber Fnumber tINT Fnumber tSTRING
		{
			$$ = NewfBmText($2, $3, $4, $5, $6, $7, $8);
		}
		| tFBMBUMP Fnumber Fnumber Fnumber Fnumber tINT
		{
			$$ = NewfBmBumpText($2, $3, $4, $5, $6);
		}
		| tWOOD
		{
			$$ = NewWoodText();
		}
		;
Child		: Childdef Textures
		{
			LastObj->texture = CurText;
			CurText = (Texture *)0;
			LastObj = (Object *)0;
		}
		;
Childdef	: tOBJECT String Transforms
		{
			LastObj = add_child_named($2, CurObj->data);
			if (CurTrans) {
				transform_bounds(CurTrans, LastObj->bounds);
				invert_trans(&CurITrans, CurTrans);
				if (LastObj->trans) {
					mmult(&LastObj->trans->obj2world,
						CurTrans,
						&LastObj->trans->obj2world);
					mmult(&LastObj->trans->world2obj,
						&CurITrans,
						&LastObj->trans->world2obj);
				} else
					LastObj->trans = new_trans(CurTrans,
								&CurITrans);
				free((char *)CurTrans);
				CurTrans = (TransInfo *)NULL;
			}
		}
		;
Transforms	: Transforms Transform
		| /* empty */
		;
Transform	: tTRANSLATE Vector
		{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			translate(CurTrans, &($2));
		}
		| tROTATE Vector Fnumber
		{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();

			rotate(CurTrans, &($2), deg2rad($3));
		}
		| tSCALE Fnumber Fnumber Fnumber
		{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			scale(CurTrans, $2, $3, $4);
		}
		| tTRANSFORM Fnumber Fnumber Fnumber
				Fnumber Fnumber Fnumber
				Fnumber Fnumber Fnumber
		{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			explicit_trans(CurTrans,
				$2, $3, $4, $5, $6, $7, $8, $9, $10,
				0., 0., 0., CurTrans);
		}
		| tTRANSFORM Fnumber Fnumber Fnumber
				Fnumber Fnumber Fnumber
				Fnumber Fnumber Fnumber
				Fnumber Fnumber Fnumber
		{
			if (CurTrans == (TransInfo *)0)
				CurTrans = new_transinfo();
			explicit_trans(CurTrans,
				$2, $3, $4, $5, $6, $7, $8, $9, $10,
				$11, $12, $13,CurTrans);
		}
		;
Eyep		: tEYEP Vector Transforms
		{
			eyep = $2;
			if (CurTrans) {
				transform_point(&eyep, CurTrans);
				free((char *)CurTrans);
				CurTrans = (TransInfo *)0;
			}
		}
		;
Lookp		: tLOOKP Vector
		{
			lookp = $2;
		}
		;
Up		: tUP Vector
		{
			up = $2;
		}
		;
Fov		: tFOV Fnumber Fnumber
		{
			hfov = $2; vfov = $3;
		}
		| tFOV Fnumber
		{
			hfov = $2;
		}
		;
Samples		: tSAMPLES tINT
		{
			if (JitSamples == UNSET)
				JitSamples = $2;
		}
		;
Adaptive	: tADAPTIVE tINT
		{
			if (pixel_div == UNSET && !Jittered)
				pixel_div = $2;
		}
		;
Contrast	: tCONTRAST Fnumber Fnumber Fnumber
		{
			if (RedContrast == UNSET ||
			    GreenContrast == UNSET ||
			    BlueContrast == UNSET) {
				RedContrast = $2;
				GreenContrast = $3;
				BlueContrast = $4;
			}
		}
		;
Cutoff		: tCUTOFF Fnumber
		{
			if (TreeCutoff == UNSET)
				TreeCutoff = $2;
		}
		;
Jittered	: tJITTERED
		{
			if (pixel_div == UNSET)
				Jittered = TRUE;
		}
		;
Screen		: tSCREEN tINT tINT
		{
			if (Xres == UNSET || Yres == UNSET) {
				Xres = $2;
				Yres = $3;
			}
		}
		| tRESOLUTION tINT tINT
		{
			if (Xres == UNSET || Yres == UNSET) {
				Xres = $2;
				Yres = $3;
			}
		}
		;
Maxdepth	: tMAXDEPTH tINT
		{
			maxlevel = $2;
		}
		;
Background	: tBACKGROUND Color
		{
			background = $2;
		}
		;
Light		: Lightdef tPOINT Vector
		{
			light[nlight].pos = $3;
			light[nlight].type = LOCAL;
			nlight++;
		}
		| Lightdef tDIRECTIONAL Vector
		{
			(void)normalize(&($3));
			light[nlight].pos = $3;
			light[nlight].type = DIRECTIONAL;
			nlight++;
		}
		| Lightdef tEXTENDED Vector Fnumber
		{
			light[nlight].pos = $3;
			light[nlight].radius = $4;
			light[nlight].type = EXTENDED;
			nlight++;
		}
		;
Lightdef	: tLIGHT Fnumber
		{
			if (nlight == LIGHTS)
				yyerror("Too many lights.");
			light[nlight].color.r = $2;
			light[nlight].color.g = $2;
			light[nlight].color.b = $2;
		}
		| tLIGHT Color
		{
			if (nlight == LIGHTS)
				yyerror("Too many lights.\n");
			light[nlight].color = $2;
		}
		;
Surface		: tSURFACE String
			Color Color Color
			Fnumber Fnumber Fnumber Fnumber
		{
			/*
			 * surface name
			 * 	amb
			 * 	diff
			 * 	spec coef reflect refract krefract
			 */
			stmp = make_surface($2, &($3), &($4), &($5), $6, $7,
					$8, $9, 0., 0.);
			Surfaces = add_surface(stmp, Surfaces);

		}
		| tSURFACE String Color Color Color
			Fnumber Fnumber Fnumber Fnumber Fnumber Fnumber
		{
			/*
			 * surface name
			 * 	amb
			 * 	diff
			 * 	spec coef reflect refract krefract
			 */
			stmp = make_surface($2, &($3), &($4), &($5), $6, $7,
					$8, $9, $10, $11);
			Surfaces = add_surface(stmp, Surfaces);

		}
		;
HeightField	: tHEIGHTFIELD tSTRING tSTRING
		{
			LastObj = makhf($2, $3);
		}
		;
Poly		: tPOLY tSTRING Polypoints
		{
			LastObj = makpoly($2, Polypoints, Npoints);
			Polypoints = (PointList *)0;
			Npoints = 0;
		}
		;
Polypoints	: /* empty */
		| Polypoints Polypoint
		;
Polypoint	: Vector
		{
			Point = (PointList *)Malloc(sizeof(PointList));
			Point->vec = $1;
			Point->next = Polypoints;
			Polypoints = Point;
			Npoints++;
		}
		;
Cone		: tCONE tSTRING Vector Vector Fnumber Fnumber
		{
			CurTrans = new_transinfo();
			LastObj = makcone($2, &($3), &($4), $5, $6, CurTrans);
		}
		;
Cylinder	: tCYL tSTRING Vector Vector Fnumber
		{
			/*
			 * Cylinders automagically define a
			 * transformation matrix.
			 */
			CurTrans = new_transinfo();
			LastObj = makcyl($2, &($3), &($4), $5, CurTrans);
		}
		;
Sphere		: tSPHERE tSTRING Fnumber Vector
		{
			LastObj = maksph($2, $3, &($4));
		}
		;
Box		: tBOX tSTRING
			Fnumber Fnumber Fnumber
			Fnumber Fnumber Fnumber
		{
			LastObj = makbox($2, $3, $4, $5, $6, $7, $8);
		}
		;
Triangle	: tTRIANGLE tSTRING Vector Vector Vector
		{
			LastObj = maktri(TRIANGLE, $2, &($3), &($4), &($5),
					(Vector *)0, (Vector *)0, (Vector *)0);
		}
		| tTRIANGLE tSTRING Vector Vector Vector Vector Vector Vector
		{
			LastObj = maktri(PHONGTRI, $2, &($3), &($5),
					&($7), &($4), &($6), &($8));
		}
		;
Superq		: tSUPERQ tSTRING
			Fnumber Fnumber Fnumber
			Fnumber Fnumber Fnumber
			Fnumber
		{
			LastObj = maksup($2, $3, $4, $5, $6, $7, $8, $9);
		}
		;
Plane		: tPLANE tSTRING Vector Vector
		{
			LastObj = makplane($2, &($3), &($4));
		}
		;
Outfile		: tOUTFILE String
		{
			if (*outfilename != (char)NULL)
				fprintf(stderr,"Ignoring output name \"%s\"\n",
					$2);
			else
				strcpy(outfilename, $2);
		}
		;
Mist		: tMIST Color Color Fnumber Fnumber
		{
			GlobalMist = (Mist *)Malloc(sizeof(Mist));
			GlobalMist->color = $2;
			GlobalMist->trans = $3;
			GlobalMist->zero = $4;
			GlobalMist->scale = 1. / $5;
		}
		;
Fog		: tFOG Fnumber Color
		{
			GlobalFog = (Fog *)Malloc(sizeof(Fog));
			GlobalFog->trans = 1./$2;
			GlobalFog->color = $3;
		}
		;
Color		: Fnumber Fnumber Fnumber
		{
			$$.r = $1;
			$$.g = $2;
			$$.b = $3;
		}
		;
Vector		: Fnumber Fnumber Fnumber
		{
			$$.x = $1;
			$$.y = $2;
			$$.z = $3;
		}
		;
Fnumber		: tFLOAT
		{ $$ = $1;}
		| tINT
		{ $$ = $1;}
		;
String		: tSTRING
		{ $$ = $1;}
%%
yyerror(s)
char *s;
{
	extern char tmpname[];

	fprintf(stderr,"rayshade: line %d: %s\n", yylineno, s);
	unlink(tmpname);
	exit(2);
}

