/*
 * atmosphere.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: atmosphere.c,v 3.0 89/10/27 02:05:46 craig Exp $
 *
 * $Log:	atmosphere.c,v $
 * Revision 3.0  89/10/27  02:05:46  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include <math.h>
#include "typedefs.h"
#include "constants.h"
#include "funcdefs.h"

Fog *GlobalFog;
Mist *GlobalMist;

/*
 * Add fog to the given color.
 */
ComputeFog(fog, dist, color)
Fog *fog;
double dist;
Color *color;
{
	double atten;

	atten = LNHALF * dist * fog->trans;
	if (atten < -10.)
		atten = 0.;
	else
		atten = exp(atten);
	blend_color(color, &fog->color, atten, 1. - atten);
}

/*
 * Add low-altitude mist to the given color.
 */
ComputeMist(mist, origin, hit, dist, color)
Mist *mist;
Vector *origin, *hit;
double dist;
Color *color;
{
	double deltaZ, d, atten;

	deltaZ = mist->scale * (hit->z - origin->z);
	if (abs(deltaZ) > EPSILON)
		d = (exp(-origin->z*mist->scale + mist->zero) -
			    exp(-hit->z*mist->scale + mist->zero)) / deltaZ;
	else
		d = exp(-hit->z*mist->scale + mist->zero);
	d *= LNHALF * dist;
	atten =  d /  mist->trans.r;
	atten = (atten < -10. ? (0.) : exp(atten));
	color->r = atten*color->r + (1. - atten)*mist->color.r;

	atten =  d /  mist->trans.g;
	atten = (atten < -10. ? (0.) : exp(atten));
	color->g = atten*color->g + (1. - atten)*mist->color.g;

	atten =  d /  mist->trans.b;
	atten = (atten < -10. ? (0.) : exp(atten));
	color->b = atten*color->b + (1. - atten)*mist->color.b;
}
