/*
 * viewing.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: viewing.c,v 3.0 89/10/27 02:06:08 craig Exp $
 *
 * $Log:	viewing.c,v $
 * Revision 3.0  89/10/27  02:06:08  craig
 * Baseline for first official release.
 * 
 */
#include <math.h>
#include <stdio.h>
#include "constants.h"
#include "typedefs.h"
#include "funcdefs.h"

Vector lookp, eyep, up, firstray, scrnx, scrny;
double vfov, hfov, Separation;
int Xres = UNSET, Yres = UNSET, Stereo;
viewing()
{
	Vector gaze;
	double dist, magnitude;

	vecsub(lookp, eyep, &gaze);
	firstray = gaze;

	dist = normalize(&gaze);
	(void)crossp(&scrnx, &gaze, &up);
	(void)crossp(&scrny, &scrnx, &gaze);
	dist *= 2.0;

	/*
	 * Add stereo separation if desired.
	 */
	if (Stereo) {
		if (Stereo == LEFT)
			magnitude = -.5 * Separation;
		else
			magnitude = .5 * Separation;
		eyep.x += magnitude * scrnx.x;
		eyep.y += magnitude * scrnx.y;
		eyep.z += magnitude * scrnx.z;
		vecsub(lookp, eyep, &firstray);
		gaze = firstray;
		dist = normalize(&gaze);
		(void)crossp(&scrnx, &gaze, &up);
		(void)crossp(&scrny, &scrnx, &gaze);
	}

	magnitude = dist * tan(deg2rad(0.5*hfov)) / Xres;
	scrnx.x *= magnitude;
	scrnx.y *= magnitude;
	scrnx.z *= magnitude;
	magnitude = dist * tan(deg2rad(0.5*vfov)) / Yres;
	scrny.x *= magnitude;
	scrny.y *= magnitude;
	scrny.z *= magnitude;

	firstray.x += 0.5*Yres*scrny.x - 0.5*Xres*scrnx.x;
	firstray.y += 0.5*Yres*scrny.y - 0.5*Xres*scrnx.y;
	firstray.z += 0.5*Yres*scrny.z - 0.5*Xres*scrnx.z;
}
