char rcsid[] =
	"$Id: main.c,v 3.0 89/10/27 17:05:45 craig Exp $";
/*
 * main.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	main.c,v $
 * Revision 3.0  89/10/27  17:05:45  craig
 * Baseline for first official release.
 * 
 */
#include <stdio.h>
#include <signal.h>
#ifdef SYSV
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#else
#ifndef AZTEC_C
#include <sys/time.h>
#include <sys/resource.h>
#endif
#endif
#include "constants.h"
#include "typedefs.h"
#include "defaults.h"

unsigned long	EyeRays,	/* # of eye rays spawned */
		ShadowRays,	/* # of shadow rays spawned */
		ReflectRays,	/* # of reflected rays */
		RefractRays,	/* # of refracted rays */
		HitRays,	/* # of rays which hit something. */
		BVTests,	/* # of bounding volume tests. */
		SuperSampled;	/* # of supersampled pixels. */
double		ftmp;		/* Used by fabs() macro. */
FILE		*fstats;	/* Statistics file */

/*
 * LINDA silliness.
 */
#ifdef LINDA
rayshade_main(argc, argv)
#else
main(argc, argv)
#endif
int argc;
char **argv;
{
	double utime, stime;
	unsigned long TotalRays;
	extern int Verbose, Cache;
	extern unsigned long CacheWorked, CacheFailed, ShadowHits;

	/*
 	 * Initialize variables, etc.
	 */
	setup();
	/*
	 * Parse options from command line.
	 */
	parse_options(argc, argv);
	/*
	 * Process input file.
	 */
	if (Verbose) {
		print_version();
		fprintf(fstats,"Reading input file...\n");
		fflush(fstats);
	}
	read_input_file();
	/*
	 * Set variables which weren't set on command line
	 * or in input file.
	 */
	cleanup();
	/*
	 * Start new picture.
	 */
	startpic();
	/*
	 * Set up viewing parameters.
	 */
	viewing();
	/*
	 * Set up world.
	 */
	if (Verbose)
		fprintf(fstats,"Setting up voxels...\n");
	SetupWorld();
	get_cpu_time(&utime, &stime);
	fprintf(fstats,"Preprocessing time:\t");
	fprintf(fstats,"%2.2lfu  %2.2lfs\n",utime, stime);
	fprintf(fstats,"Starting trace.\n");
	fflush(fstats);
	/*
	 * Trace the image.
	 */
	raytrace();
	/*
	 * Close the image file.
	 */
	endpic();

	get_cpu_time(&utime, &stime);

#ifndef LINDA
	TotalRays = EyeRays + ShadowRays + ReflectRays + RefractRays;
	ShadowHits += CacheWorked;
	HitRays += ShadowHits;
	fprintf(fstats,"Eye rays:\t\t\t%ld\n", EyeRays);
	fprintf(fstats,"Shadow rays:\t\t\t%ld\n",ShadowRays);
	fprintf(fstats,"Reflected rays:\t\t\t%ld\n",ReflectRays);
	fprintf(fstats,"Refracted rays:\t\t\t%ld\n",RefractRays);
	fprintf(fstats,"Total rays:\t\t\t%ld\n", TotalRays);
	if (TotalRays != 0.)
		fprintf(fstats,"Intersecting rays:\t\t%ld (%3.3f%%)\n",
			HitRays, 100. * (float)HitRays / (float)TotalRays);
	if (ShadowRays != 0) {
		if (Cache)
			fprintf(fstats,"Shadow cache hits:\t\t%ld (%ld misses)\n",
				CacheWorked, CacheFailed);
		fprintf(fstats,"Total shadow hits:\t\t%ld (%3.3f%%)\n",
			ShadowHits, 100.*(float)ShadowHits / (float)ShadowRays);
	}
	fprintf(fstats,"Supersampled pixels:\t\t%ld\n",SuperSampled);
	fprintf(fstats,"B.V. intersection tests:\t%ld\n", BVTests);
	print_prim_stats();
#endif
	fprintf(fstats,"Total CPU time (sec):\t\t");
	fprintf(fstats,"%2.2lf (%2.2lfu + %2.2lfs)\n",utime+stime, utime, stime);
#ifndef LINDA
	if (TotalRays != 0.)
		fprintf(fstats,"Seconds / ray:\t\t\t%4.4lf\n",
				(utime + stime) / (double)TotalRays);
	if (HitRays != 0.)
		fprintf(fstats, "Seconds / intersecting ray:\t%4.4lf\n",
				(utime + stime) / (double)HitRays);
#endif
	PrintMemoryStats();
	exit(0);
}

#ifdef SYSV
get_cpu_time(utime, stime)
double *utime, *stime;
{
	struct tms time;
	long times();

	(void)times(&time);
	*utime = (double)time.tms_utime / (double)HZ;
	*stime = (double)time.tms_stime / (double)HZ;
}
#else
#ifdef AZTEC_C
get_cpu_time()
{
}
#else	/* !SYSV && !AZTEC_C */
get_cpu_time(utime, stime)
double *utime, *stime;
{
	struct rusage usage;

	getrusage(RUSAGE_SELF, &usage);

	*utime = (double)usage.ru_utime.tv_sec +
			(double)usage.ru_utime.tv_usec / 1000000.;
	*stime = (double)usage.ru_stime.tv_sec +
			(double)usage.ru_stime.tv_usec / 1000000.;
}
#endif
#endif
