#include <stdio.h>
#include <quadtree.h>

extern int      optind;
extern char    *optarg;

main(argc, argv)
{
    QT_Bitmap_t     Bitmap;
    QT_TreeNode_t  *root;
    int             c;
    char            fmt = 0;

    while ((c = getopt(argc, argv, "12")) != EOF) {
	switch (c) {
	    case '1':
	    case '2':
		fmt = c - '1';
		break;
	}
    }
    QT_Bitmap_Read(&Bitmap, stdin);
    root = QT_BitmapToTree(&Bitmap);
    QT_Tree_Write(stdout, root, fmt,
		  QT_Bitmap_Width(&Bitmap),
		  QT_Bitmap_Height(&Bitmap));
    exit(0);
}
