typedef struct {
    short           x, y, width, height, fullwidth, fullheight;
    char           *bits;
}               QT_Bitmap_t;

typedef struct _QT_TreeNode {
    short           color;
    struct _QT_TreeNode *children[4];
}               QT_TreeNode_t;

#define QT_Bitmap_Width(b) ((b)->width)
#define QT_Bitmap_Height(b) ((b)->height)

#define QT_TreeNode_Color(t) ((t)->color)
#define QT_TreeNode_Child(t,n) ((t)->children[n])
#define QT_TreeNode_UpperLeft(t) (QT_TreeNode_Child((t),0))
#define QT_TreeNode_UpperRight(t) (QT_TreeNode_Child((t),1))
#define QT_TreeNode_LowerLeft(t) (QT_TreeNode_Child((t),2))
#define QT_TreeNode_LowerRight(t) (QT_TreeNode_Child((t),3))
#define QT_TreeNode_SetColor(t,c) (((t)->color)=(c))
#define QT_TreeNode_SetUpperLeft(t,v) (((t)->children[0])=(v))
#define QT_TreeNode_SetUpperRight(t,v) (((t)->children[1])=(v))
#define QT_TreeNode_SetLowerLeft(t,v) (((t)->children[2])=(v))
#define QT_TreeNode_SetLowerRight(t,v) (((t)->children[3])=(v))

extern QT_TreeNode_t *QT_BitmapToTree();
extern int      QT_Bitmap_Bit();
extern int      QT_Bitmap_Init();
extern int      QT_Bitmap_Read();
extern void     QT_Bitmap_SetBit();
extern void     QT_TreeNode_Destroy();
extern QT_TreeNode_t *QT_TreeNode_New();
extern QT_TreeNode_t *QT_Tree_Read();
extern void     QT_Tree_Write();
