/*LINTLIBRARY*/

/*  @(#)xview.c 1.8 89/12/11
 *
 *  XView dependent graphics routines used by popi.
 *  written by Rich Burridge - Sun Microsystems.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"
#include "graphics.h"
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/cms.h>
#include <xview/cursor.h>
#include <X11/Xlib.h>

#define  NOTIFY_DISPATCH                (void) notify_dispatch
#define  NOTIFY_INTERPOSE_DESTROY_FUNC  (void) notify_interpose_destroy_func
#define  PW_WRITEBACKGROUND             (void) pw_writebackground
#define  WINDOW_DONE                    (void) window_done
#define  XV_SET                         (void) xv_set

#define  BOLD_FONT      "/usr/lib/fonts/fixedwidthfonts/screen.b.14"
#define  NORMAL_FONT    "/usr/lib/fonts/fixedwidthfonts/screen.r.14"

void repaint_canvas() ;

Canvas canvas ;
Canvas_paint_window cpw ;
Display *dpy ;
Event event ;
Frame frame ;
Icon popi_icon ;
Notify_value destroy_proc() ;
Pixfont *bfont, *font, *nfont, *xv_pf_default(), *xv_pf_open() ;
Pixrect *pr, *xv_mem_create() ;                /* Offscreen image area. */
Xv_cmsdata cms_data ;
Xv_Cursor busy_cursor, main_cursor ;

unsigned short busy_cursor_array[] = {
#include <images/hglass.cursor>
} ;
mpr_static(busy_cursor_pr, 16, 16, 1, busy_cursor_array) ;

unsigned short icon_image[] = {
#include "popi.icon"
} ;
mpr_static(icon_pr, 64, 64, 1, icon_image) ;

int blocking ;       /* Set if in event blocking mode. */
int gotevent ;       /* Set if we have an event to handle. */
int nonblocking ;    /* Set if in event non-blocking mode. */
int oktoshow ;       /* Set just before window is displayed. */
int win_depth ;      /* Depth in pixels of this display. */


/*ARGSUSED*/
void
canvas_proc(canvas, e, arg)
Canvas canvas ;
Event *e ;
caddr_t arg ;
{
  if (!oktoshow) return ;
  event = *e ;
  gotevent = 1 ;
  if (blocking) (void) notify_stop() ;
}


cleanup()            /* Null routine for the XView version. */
{
}


/*ARGSUSED*/
Notify_value
destroy_proc(client, status)
Notify_client client ;
Destroy_status status ;
{
  exit(0) ;
}


draw_scanline(line, y)       /* Display image scanline on the screen. */
unsigned char *line ;
int y ;
{
  int i ;

  mptr = (unsigned char *) ((struct mpr_data *) pr->pr_data)->md_image ;
  if (iscolor)
    for (i = 0; i < Xsize; i++) mptr[i] = 255 - line[i] ;
  else halftone(line, y) ;
  (void) pw_rop(cpw, 0, y+100, Xsize, 1, PIX_SRC, pr, 0, 0) ;
}


drawarea(x, y, width, height, op)
int x, y, width, height ;
enum op_type op ;
{
  PW_WRITEBACKGROUND(cpw, x, y, width, height, ops[(int) op]) ;
  XSync(dpy, 0) ;
}


drawline(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
  (void) pw_vector(cpw, x1, y1, x2, y2, PIX_SET, 0) ;
}


drawtext(x, y, fontno, str)
enum font_type fontno ;
int x, y ;
char *str ;
{
  if (fontno == NFONT) font = nfont ;
  else if (fontno == BFONT) font = bfont ;
  (void) pw_text(cpw, x, y, PIX_SRC, font, str) ;
}


Pixfont *
get_font(name)
char *name ;
{
  Pixfont *font ;

  font = xv_pf_open(name) ;
  if (font == NULL) font = xv_pf_default() ;
  if (font == NULL)
    {
      perror("couldn't get the default font.") ;
      exit(1) ;
    }
  return font ;
}


get_event()       /* Get the next XView event. */
{
  if (!gotevent)
    {
      XSync(dpy, 0) ;
      notify_start() ;     /* This blocks until notify_stop. */
    }
  gotevent = 0 ;
}


get_next_char(c)      /* Process events, and return when character typed. */
char *c ;
{
  for (;;)
    {
      get_event() ;
      if (event_is_ascii(&event) && event_is_up(&event))  /* Keyboard char? */
        {
          *c = event_id(&event) ;
          return ;
        }
      else if (event_id(&event) == WIN_REPAINT) paint_canvas() ;
    }
}


init_fonts()
{
  bfont = get_font(BOLD_FONT) ;
  nfont = get_font(NORMAL_FONT) ;
  nfont_width = nfont->pf_defaultsize.x ;
}


init_ws_type()
{
  ops[(int) GCLR] = PIX_CLR ;
  ops[(int) GSET] = PIX_SET ;
  oktoshow = 0 ;       /* Kludge to correctly handle repaints. */
  blocking = 1 ;
  return 0 ;
}


make_items(argc, argv)       /* Create icon, frame, canvas etc.. */
int argc ;
char *argv[] ;
{
  int i ;
  char cmsname[MAXLINE] ;
  u_char red[CMAPLEN], green[CMAPLEN], blue[CMAPLEN] ;

  xv_init(XV_INIT_ARGS, argc, argv, 0);
  popi_icon = xv_create(0, ICON,
                        ICON_IMAGE, &icon_pr,
                        0) ;
  frame = xv_create(0, FRAME,
                    FRAME_ICON,       popi_icon,
                    FRAME_SHOW_LABEL, FALSE,
                    FRAME_NO_CONFIRM, TRUE,
                    XV_HEIGHT,        THEIGHT,
                    XV_WIDTH,         TWIDTH,
                    0) ;
  iscolor = ((win_depth = (int) xv_get(frame, WIN_DEPTH)) > 1) ? 1 : 0 ;

  pr = xv_mem_create(Xsize, 1, win_depth) ;

  SPRINTF(cmsname, "popi%10ld", getpid()) ;
  for (i = 0; i < CMAPLEN; i++)
    red[i] = green[i] = blue[i] = 255 - i ;

  cms_data.type = XV_DYNAMIC_CMS ;
  cms_data.size = 256 ;
  cms_data.rgb_count = 256 ;
  cms_data.index = 0 ;
  cms_data.red = red ;
  cms_data.green = green ;
  cms_data.blue = blue ;

  canvas = xv_create(frame, CANVAS,
                     OPENWIN_AUTO_CLEAR,       FALSE,
                     CANVAS_RETAINED,          TRUE,
                     XV_WIDTH,                 TWIDTH,
                     XV_HEIGHT,                THEIGHT,
                     CANVAS_PAINTWINDOW_ATTRS,
                         WIN_DYNAMIC_VISUAL,   TRUE,
                         WIN_CONSUME_EVENTS,
                           WIN_ASCII_EVENTS,
                           WIN_LEFT_KEYS, WIN_TOP_KEYS, WIN_RIGHT_KEYS,
                           0,
                         WIN_IGNORE_EVENTS,
                           LOC_MOVE, LOC_DRAG,
                           0,
                         WIN_EVENT_PROC, canvas_proc,
                         0,
                     0) ;
 
  cpw = canvas_paint_window(canvas) ;
  XV_SET(/**canvas_pixwin(canvas),**/cpw,
           WIN_CMS_NAME, cmsname,
           WIN_CMS_DATA,  &cms_data,
         0) ;
  dpy = (Display *) xv_get(cpw, XV_DISPLAY) ;

  main_cursor = xv_get(canvas, WIN_CURSOR) ;
  busy_cursor = xv_create(NULL, CURSOR,
                          CURSOR_IMAGE, &busy_cursor_pr,
                          0) ;
}


set_cursor(type)
enum cur_type type ;
{
  switch (type)
    {
      case BUSY_CUR   : XV_SET(canvas, WIN_CURSOR, busy_cursor, 0) ;
                        break ;
      case NORMAL_CUR : XV_SET(canvas, WIN_CURSOR, main_cursor, 0) ;
    }
  XSync(dpy, 0) ;
}


start_tool()
{
  window_fit(frame) ;
  NOTIFY_INTERPOSE_DESTROY_FUNC(frame, destroy_proc) ;
  XV_SET(frame, WIN_SHOW, TRUE, 0) ;
  oktoshow = 1 ;
  (void) xv_set(xv_default_server, SERVER_SYNC_AND_PROCESS_EVENTS) ;
  NOTIFY_DISPATCH() ;
}
