/* @(#)popi.h 1.10 89/12/11
 *
 *  Definitions and constants used by the popi program.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#ifndef	POPI_DEFINED
#define POPI_DEFINED

#if defined(MSDOS) && defined(M_I86)
/* Assume we are Microsoft C */
# define __MSC__ 1
#endif	/* MSC */

/*
 * Some compilers are near enough to ANSI for our purposes.
 * In some situations the compiler has a true ANSI mode which
 * we should set if possible. But sometimes we can't because
 * we need non-standard features of the compiler (eg far pointers
 * under DOS). We can't just set __STDC__ ourselves in these cases
 * because their include files need to know the truth. So we
 * set the token STDC which means that as far as we're concerned
 * we are ANSI.
 */

#if defined(__STDC__) || defined(__TURBOC__) || defined(__MSC__)
# define STDC	1
#endif	/* __STDC__ || __TURBOC__ || __MSC__ */

#if defined(STDC) && ! defined(apollo)

# include <stdlib.h>

#else	/* ! STDC || apollo */

/* No <stdlib.h> */
/* We can't define these as well as including <stdlib.h> because
 * some compilers (eg Turbo C) use silly nonstandard keywords (which
 * we can't #define away) as part of the type.
 */
extern char
	    *malloc(),
	    *getenv(),
# ifdef	   BSD
	    *sprintf();
# endif  /* BSD */
#endif	/* STDC && !apollo */

#if defined(STDC) || ! defined(BSD)
# include <string.h>
#else
# include <strings.h>
#endif	/* STDC || ! BSD */

/*
 *	For all function declarations, if ANSI then use a prototype.
 */
#if	defined(STDC)
# define P(args)	args
#else	/* ! STDC */
# define P(args)	()
#endif	/* STDC */

#ifndef	FILE
# include	<stdio.h>
#endif	/* FILE */
#ifndef assert
# include	<assert.h>
#endif	/* assert */

/*
 * The assumption we make here is that not all versions of <math.h>
 * define M_PI, but they all define HUGE.
 */
#ifndef M_PI
# ifndef	HUGE
#  include <math.h>
# endif		/* HUGE */

# ifndef	M_PI
#  define M_PI	3.14159265358979323846
# endif		/* M_PI */
#endif /* M_PI */
extern double
	pow P((double, double)),
	sin P((double)),
	cos P((double)),
	atan2 P((double, double)),
	hypot P((double, double)),
	log P((double)),
	sqrt P((double));

#define NELS(arr)	(sizeof (arr) / sizeof (*(arr)))

#define DtoR(degrees)	((degrees) * M_PI * 2.0 / 360.0)
#define RtoD(radians)	((radians) / (M_PI * 2.0 / 360.0))

#define BITSINBYTE	8

/*
 * define RANDOM to be an expression which returns a value
 * between 0 and some large number (like maxint or maxlong).
 */
#if	defined(BSD)
# define RANDOM		random()
extern long		random P((void));
#else	/* ! BSD */
# if	defined(SYSV)
#  define RANDOM		lrand48()
extern long		lrand48 P((void));
# else	/* ! SYSV */
#  define RANDOM		rand()
extern int		rand P((void));
# endif	/* SYSV */
#endif	/* BSD */

typedef long		stack_t;
typedef long		parse_t;
typedef unsigned char	pixel_t;
typedef int		bool;

#ifndef	FALSE
# define FALSE		0
# define TRUE		1
#endif	/* FALSE */


/* To make lint happy. */

#define FCLOSE		(void) fclose
#define FFLUSH          (void) fflush
#define FPRINTF  	(void) fprintf
#define FPUTS		(void) fputs
#define FREAD    	(void) fread
#define FWRITE   	(void) fwrite
#define IOCTL           (void) ioctl
#define PCLOSE		(void) pclose
#define PRINTF   	(void) printf
#define PUTC            (void) putc
#define SELECT          (void) select
#define SIGNAL          (void) signal
#define SPRINTF         (void) sprintf
#define STRCAT          (void) strcat
#define STRCPY   	(void) strcpy
#define STRNCAT		(void) strncat
#define STRNCPY		(void) strncpy
#define UNGETC   	(void) ungetc
#define WRITE           (void) write

#ifndef LINT_CAST
#ifdef lint
#define LINT_CAST(arg)  (arg ? 0 : 0)
#else
#define LINT_CAST(arg)  (arg)
#endif /* lint */
#endif /* LINT_CAST */

#define PUTCHAR(ch)	(void) putc(ch, stderr)

#define BACKSPACE       8            /* for input line parsing. */
#define DEL             127
#define LINEFEED        13
#define RETURN          10

#define BITSPERPIXEL    8
#define BOXH            40           /* height of input dialog box. */
#define BOXW            (TWIDTH-40)  /* width of input dialog box. */
#define BOXX            20           /* x position of input dialog box. */
#define BOXY            10           /* y position of input dialog box. */
#define CMAPLEN         256          /* length of the color map. */
#define DEF_X           512          /* image width */
#define DEF_Y           512          /* image height */
#define DEF_ZSIZE       (1 << BITSPERPIXEL)
#define MAXIMG          128

#ifndef MAXLINE
#define MAXLINE         80           /* length of character strings. */
#endif  /*MAXLINE*/

#define MAXOPS		2            /* number of pseudo rasterop functions. */
#define MAXTOKENS	128

#ifndef  SIGRET
#define  SIGRET         int
#endif /* SIGRET */

#define THEIGHT         612          /* total height of the popi window. */
#define TWIDTH          512          /* total width of the popi canvas. */

#define ERR_NONE	0
#define ERR_SYS		(1<<0)       /* system error (errno set) */
#define ERR_PARSE	(1<<1)	     /* syntax error while parsing input */
#define ERR_SNARK	(1<<2)	     /* internal program error */
#define ERR_WARN	(1<<3)	     /* just a warning */

/* larger than any char token. */
#define CRVAL	257	/* cartesian image coordinate rval */
#define CLVAL	258	/* cartesian image coordinate lval */
#define INAME	259	/* image name */
#define VALUE	260
#define NAME	261
#define NEW	262
#define AND	264	/* && */
#define OR	265	/* || */
#define EQ	266	/* == */
#define NE	267	/* != */
#define GE	268	/* >= */
#define LE	269	/* <= */
#define UMIN	270	/* unary minus */
#define POW	271	/* ** */
#define LSHIFT	272	/* << */
#define RSHIFT	273	/* >> */
#define SPECIAL	274
#define INUM	275	/* integer number */
#define FNUM	276	/* floating point number */
#define PLVAL	277	/* polar image coordinate lval */
#define PRVAL	278	/* polar image coordinate rval */
#define FNAME	279	/* Filename */
#define SIN	300	/* sine() * Z */
#define COS	301	/* cosine() * Z */
#define ATAN	302	/* atan2(y, x) */
#define ABS	303	/* abs() */
#define LOG	304	/* natural log */
#define SQRT	305
#define RAND	306	/* RANDOM() as defined above */
#define HYPOT	307	/* hypot(x, y) == sqrt(x*x + y*y) */

#ifdef	NDEBUG
#  define DEBUG(stuff)
#else	/* ! NDEBUG */
#  define DEBUG(stuff)	if (Debug) FPRINTF stuff
#endif	/* ! NDEBUG */

enum cur_type { BUSY_CUR, NORMAL_CUR } ; /* cursor types. */

enum font_type { BFONT, NFONT } ;        /* fonts used by popi. */

enum op_type  { GCLR, GSET } ;           /* pseudo rasterop functions. */

struct SRC
{
	pixel_t		**pix;    /* pix[y][x] */
	char		*str;
};

/* An element of the execution string.
 * Each such item will perform some operation on the
 * evaluation stack.
 */
typedef
struct exec
{
    int		op;
    union
    {
	long	i;	/* integer */
	float	f;	/* floating point */
    } value;
} exec_t;

#if	SEQPAR
#ifndef	sequent
#include "Sorry, this will only work on a sequent"
#endif	/* sequent */
#define malloc	shmalloc
#endif	/* SEQPAR */

/* External declarations */

/* main.c */
extern char	*Emalloc P((unsigned int));
extern void	PrStrs P((char **));
extern void	version P((void));

/* io.c */
extern pixel_t	**ImgAlloc P((void));
extern void	ImgFree P((struct SRC *));
extern void	Efclose P((FILE *));
extern FILE	*EfopenR P((char *)),
		*EfopenW P((char *));
extern void	getpix P((char *, char *));
extern void	putpix P((struct SRC *, char *));
extern void	showfiles P((void));

/* lex.c */
extern void	Skip P((void));
extern void	lex P((void));
extern void	error P((int));
extern void	pushback P((int));

/* expr.c */
extern void	transform P((void));

/* special.c */
extern void	help P((void));
extern void	OpenLog P((void));
extern void	special P((void));

/* run.c */
extern void	SwapOldNew P((void));
extern void	run P((void));

/* polar.c */
extern void	MakePolar P((void));

/* driver routines */
void	disp_init P((int, char**));
void	disp_finish P((void));
void	disp_imgstart P((void));
void	disp_imgend P((void));
void	disp_putline P((pixel_t *, int));
void	disp_error P((int, int));
void	disp_ungetc P((int));
void	disp_percentdone P((int));
int	disp_prompt P((void));
int	disp_getchar P((void));

/* External variable declarations */

extern char ErrBuf[] ;
extern char *ProgName ;        /* Name of this program. */
extern char nextline[] ;       /* Next input line to be parsed. */
extern char text[] ;
extern char *LogFile ;         /* Name of file for logging commands */

extern FILE *Debug ;           /* Debugging stream */
extern FILE *LogStr ;          /* command logging stream */

extern double lexfract ;

extern short CUROLD ;
extern short CURNEW ;

extern long parsed[] ;

extern int CharPos ;           /* Position in input line. */
extern int OldPos ;
extern int RangeCheck ;
extern int Xsize ;
extern int Ysize ;
extern int Zsize ;
extern pixel_t Zmax ;
extern short *avals ;
extern int lat ;          /* Lookahead token. */
extern int lexval ;
extern int noerr ;        /* Indicates if an error has occured. */
extern int nsrc ;
extern int prs ;
extern short *rvals ;
extern int Verbose ;
extern void Skip() ;
extern int Truncate ;

extern struct SRC src[MAXIMG] ;

extern int disp_active ;       /* Display results after each operation. */

#if       SEQPAR
extern int ncpus;          /* No. cpus to use in parallel */
#endif /* SEQPAR */

#endif	/* POPI_DEFINED */
