
/*  @(#)polar.c 1.6 89/12/11
 *
 *  Polar coordinate handling routines used by the popi program.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include <stdio.h>
#include "popi.h"

short
	*avals = 0,
	*rvals = 0;

/*
 *	  +y
 *	   ^
 *       2 | 1
 * -x <----+----> +x
 *       3 | 4
 *	   v
 *	  -y
 */

#ifdef AMIGA
double
hypot(x, y)
double x, y;
{
    return(sqrt(x*x + y*y));
}
#endif	/* AMIGA */

void
MakePolar()
{
    short	*ap,	/* pointer to angle array */
		*rp,	/* pointer into radius array */
		*a1,	/* tmp pointer to angle array */
		*r1;	/* tmp pointer to radius array */
    int		x,
		y,
		xmin,
		xmax,
		ymin,
		ymax;

    if (avals)
	return;		/* previously calculated */

    avals = (short *) LINT_CAST(Emalloc((unsigned)Xsize * Ysize * sizeof(short)));
    rvals = (short *) LINT_CAST(Emalloc((unsigned)Xsize * Ysize * sizeof(short)));

    ymax =  Ysize / 2;
    ymin = -(Ysize - 1) / 2;
    xmin = -Xsize / 2;
    xmax =  (Xsize - 1) / 2;

    rp = rvals;
    ap = avals;

    for (y = ymax; y >= 0; --y)
    {
	/* Quadrant 2 */
	for (x = xmin; x < 0; ++x)
	{
	    *ap++ = (short) (RtoD(atan2((double) y, (double) x)) + 0.5);
	    *rp++ = (short) hypot((double) y, (double) x);
	}
	/* x == 0 */
	if (y == 0)
	{
	    *ap++ = 0;	/* prevent a domain error calling atan2() */
	    *rp++ = 0;
	}
	else
	{
	    *ap++ = (short) (RtoD(atan2((double) y, (double) x)) + 0.5);
	    *rp++ = (short) hypot((double) y, (double) x);
	}
	++x;
	/* remember location just before the 0 value */
	r1 = rp -2;
	a1 = ap - 2;
	/* Quadrant 1 */
	for (; x <= xmax; ++x)
	{
	    *ap++ = 180 - *a1--;
	    *rp++ = *r1--;
	}
    }
    r1 = rp - Xsize - 1;
    a1 = ap - Xsize - 1;
    for (; y >= ymin; --y)
    {
	/* Quadrant 3, 4 */
	for (x = xmin; x <= xmax; ++x)
	{
	    *rp++ = *r1--;
	    *ap++ = *a1-- + 180;
	}
    }
}
