/*LINTLIBRARY*/

/*  @(#)mgr.c 1.8 89/12/11
 *
 *  MGR dependent graphics routines used by popi.
 *  written by Rich Burridge - Sun Microsystems.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "dump.h"
#include "term.h"
#include "popi.h"
#include "graphics.h"
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>

#define  B_FONT       1    /* Font descriptors. */
#define  N_FONT       2

#define  ICONIC       0    /* States that the popi display can be in. */
#define  OPEN         1

#define  PR_ICON      1    /* Descriptor for closed icon image. */
#define  PR_SCAN      2    /* Descriptor for current popi scan line. */

#define  BOLD_FONT    "cour7x14b"
#define  NORMAL_FONT  "cour7x14r"

#define  ICONHEIGHT   64   /* Height of the popi icon. */
#define  ICONWIDTH    64   /* Width of the popi icon. */

char fontname[MAXLINE] ;   /* Full pathname of each font. */

int local_mode;            /* Used by load_icon for correct line mode. */
int mgr_infd ;             /* MGR input connection file descriptor. */
int mgr_outfd ;            /* MGR output connection file descriptor. */

short icon_image[] = {
#include "popi.icon"
} ;

#ifdef NO_43SELECT
int fullmask ;             /* Full mask of file descriptors to check on. */
int readmask ;             /* Readmask used in select call. */
#else
fd_set fullmask ;          /* Full mask of file descriptors to check on. */
fd_set readmask ;          /* Readmask used in select call. */
#endif /* NO_43SELECT */


SIGRET
clean(code)
int code ;
{
  m_bitdestroy(1) ;
  m_pop() ;
  m_ttyreset() ;
  m_clear() ;
  exit(code) ;
}


cleanup()                   /* Cleanup before exiting. */
{
  clean(0) ;
}


close_frame()
{
  reshape(ICONIC) ;
  m_clearmode(M_ACTIVATE) ;
  iconic = 1 ;
}


draw_scanline(line, y)       /* Display image scanline on the screen. */
unsigned char *line ;
int y ;
{
  int fd, size ;

  halftone(line, y) ;

  IOCTL(mgr_outfd, TIOCLGET, &local_mode) ;
  local_mode |= LLITOUT ;
  IOCTL(mgr_outfd, TIOCLSET, &local_mode) ;

  size = (Xsize / 8) + 1 ;
  m_bitldto(Xsize, 1, 0, 0, PR_SCAN, size) ;
  m_flush() ;
  WRITE(mgr_outfd, mptr, size) ;

  local_mode &= ~LLITOUT ;
  IOCTL(mgr_outfd, TIOCLSET, &local_mode) ;

  m_bitcopyto(0, y+100, Xsize, 1, 0, 0, 0, PR_SCAN) ;
}


drawarea(x, y, width, height, op)
int x, y, width, height ;
enum op_type op ;
{
  m_func(ops[(int) op]) ;
  m_bitwrite(x, y, width, height) ;
}


drawline(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
  m_func(B_COPY) ;
  m_line(x1, y1, x2, y2) ;
}


drawtext(x, y, fontno, str)
enum font_type fontno ;
int x, y ;
char *str ;
{
       if (fontno == NFONT) m_font(N_FONT) ;
  else if (fontno == BFONT) m_font(B_FONT) ;
  m_func(B_XOR) ;
  if (str[strlen(str)-1] == '\n') str[strlen(str)-1] = '\0' ;
  m_stringto(0, x, y+4, str) ;
  m_movecursor(2500, 2500) ;
}


get_next_char(c)      /* Process events, and return when character typed. */
char *c ;
{
  int chr ;
  static struct timeval tval = { 0, 0 } ;

  m_flush() ;
  for (;;)
    {
      readmask = fullmask ;
#ifdef NO_43SELECT
      SELECT(32, &readmask, 0, 0, &tval) ;
      if (readmask && (1 << mgr_infd))
#else
      SELECT(FD_SETSIZE, &readmask, (fd_set *) 0, (fd_set *) 0, &tval) ;
      if (FD_ISSET(mgr_infd, &readmask))
#endif /* NO_4.3SELECT */
        {
          if ((chr = m_getchar()) == EOF)
            {
              clearerr(m_termin) ;
              continue ;
            }
          switch (chr)
            {
              case '\032' :
              case '\033' : close_frame() ;    /* Turn window iconic. */
                            break ;
              case '\034' : clean(1) ;         /* Window destroyed. */
              case '\035' : if (iconic) iconic = 0 ;
              case '\036' : reshape(OPEN) ;
              case '\037' : paint_canvas() ;   /* Repaint popi canvas. */
                            break ;
              default     : *c = chr ;
                            return ;
            }
        }
    }
}


init_fonts()
{
  char path[MAXLINE] ;     /* Directory path for font files. */

#ifdef MGRHOME
  STRCPY(path, MGRHOME) ;
#else
  STRCPY(path, "/usr/mgr") ;
#endif

  SPRINTF(fontname, "%s/font/%s", path, NORMAL_FONT) ;
  m_loadfont(NFONT, fontname) ;
  nfont_width = 7 ;

  SPRINTF(fontname, "%s/font/%s", path, BOLD_FONT) ;
  m_loadfont(BFONT, fontname) ;
}


init_ws_type()
{
  m_setup(M_FLUSH) ;     /* Setup I/O; turn on flushing. */
  m_push(P_BITMAP | P_MENU | P_EVENT | P_FONT | P_FLAGS | P_POSITION) ;
  mgr_infd = fileno(m_termin) ;
  mgr_outfd = fileno(m_termout) ;

  SIGNAL(SIGHUP, clean) ;
  SIGNAL(SIGINT, clean) ;
  SIGNAL(SIGTERM, clean) ;
  m_ttyset() ;
  m_setraw() ;
  m_setmode(M_NOWRAP) ;
  m_setmode(M_ABS) ;
  m_setmode(ACTIVATE) ;
  m_clearmode(M_NOINPUT) ;
  m_func(B_COPY) ;

  mptr = (unsigned char *) malloc((unsigned) Xsize) ;
  ops[(int) GCLR] = B_CLEAR ;
  ops[(int) GSET] = B_SET ;
  return 0 ;
}


load_colors()                /* Hardwired to a monochrome version. */
{
  iscolor = 0 ;
}


load_icon(pixrect, ibuf)
int pixrect ;
short ibuf[256] ;
{
  int size ;

  IOCTL(mgr_outfd, TIOCLGET, &local_mode) ;
  local_mode |= LLITOUT ;
  IOCTL(mgr_outfd, TIOCLSET, &local_mode) ;

  size = ICONHEIGHT * (((64 + 15) &~ 15) >> 3) ;
  m_bitldto(ICONWIDTH, ICONHEIGHT, 0, 0, pixrect, size) ;
  m_flush() ;
  WRITE(mgr_outfd, (char *) ibuf, size) ;

  local_mode &= ~LLITOUT ;
  IOCTL(mgr_outfd, TIOCLSET, &local_mode) ;
}


make_items(argc, argv)       /* Create icon, frame, canvas etc.. */
int argc ;
char *argv[] ;
{

#ifdef NO_43SELECT
  fullmask = 1 << mgr_infd ;
#else
  FD_ZERO(&fullmask) ;
  FD_SET(mgr_infd, &fullmask) ;
#endif /* NO_4.3SELECT */
 
  m_setevent(BUTTON_2U, "\032") ;   /* Middle mouse button released. */
  m_setevent(BUTTON_1U, "\033") ;   /* Right mouse button released. */
  m_setevent(DESTROY, "\034") ;     /* Window has been destroyed. */
  m_setevent(ACTIVATE, "\035") ;    /* Window has been activated. */
  m_setevent(RESHAPE, "\036") ;     /* Check for window being reshaped. */
  m_setevent(REDRAW, "\037") ;      /* Check for window being redrawn. */

  m_movecursor(2500, 2500) ;        /* Move character cursor offscreen. */
  m_font(N_FONT) ;                  /* Default is the normal font. */
  load_icon(PR_ICON, icon_image) ;
  reshape(OPEN) ;
  m_clear() ;                       /* Clear popi window. */
  load_colors() ;                   /* Hardwired to monochrome. */
}


reshape(type)
int type ;
{
  int x, y, w, h ;      /* Position and size of calctool window. */

  get_size(&x, &y, &w, &h) ;
  switch (type)
    {
      case ICONIC : m_shapewindow(x, y, ICONWIDTH+10, ICONHEIGHT+10) ;
                    m_clear() ;
                    m_bitcopyto(0, 0, ICONWIDTH, ICONHEIGHT,
                                0, 0, 0, PR_ICON) ;
                    break ;
      case OPEN   : m_shapewindow(x, y, TWIDTH+10, THEIGHT+10) ;
    }
  m_movecursor(2500, 2500) ;
}


/*ARGUSED*/
set_cursor(type)      /* Doesn't appear to be any way to set the cursor. */
enum cur_type type ;
{
}


start_tool()          /* Null routine. */
{
}
