/*LINTLIBRARY*/

/*  @(#)nulldev.c 1.7 89/12/11
 *
 *  Popi device driver for a null device.
 *  written by Stephen Frede, Softway Pty Ltd.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"

/*  There are ten exportable routines used by the popi program.
 *
 *  These are:
 *
 *  disp_init(argc, argv)    - called from main at the start.
 *  disp_finish()            - called from main prior to exit.
 *  disp_imgstart()          - called prior to drawing an image.
 *  disp_imgend()            - called after drawing an image.
 *  disp_putline(line, y)    - to draw an image scanline.
 *  disp_getchar()           - to get the next character typed.
 *  disp_ungetc(c)           - put back the last character typed.
 *  disp_prompt()            - display popi prompt and clear input buffer.
 *  disp_error(errtype)      - display error message.
 *  disp_percentdone(n)      - display percentage value of conversion.
 */

/*ARGSUSED*/
void
disp_init(argc,argv)           /* called from main at the atart. */
int argc;
char *argv[];
{
}


void
disp_finish()                  /* called from main prior to exit. */
{
}


void
disp_imgstart()                /* called prior to drawing an image. */
{
}


void
disp_imgend()                  /* called after drawing an image. */
{
}


void
disp_putline(line, y)		/* called to draw image scanline y. */
pixel_t *line;
int y;
{
}


disp_getchar()                 /* get next user typed character. */
{
    return(getchar());
}


/*ARGSUSED*/
void
disp_ungetc(c)                 /* put back the last character typed. */
char c;
{
    UNGETC(c, stdin);
}


disp_prompt()                  /* display popi prompt. */
{
    char	*prompt = "-> ";

    PRINTF(prompt);
    return sizeof prompt - 1;
}


void
disp_error(errtype, pos)            /* display error message. */
int	errtype,
	pos;
{
    extern int  errno;
    extern char *sys_errlist[];

    if (errtype & ERR_PARSE)
    {
        int     i;
 
        for (i=1; i < pos; ++i)
            PUTC('-', stderr);
        PUTC('^', stderr);
        PUTC('\n', stderr);
    }
 
    FPRINTF(stderr, "%s\n", ErrBuf);
    /* we assume errno hasn't been reset by the preceding output */
    if (errtype & ERR_SYS)
        FPRINTF(stderr, "\t(%s)\n", sys_errlist[errno]);
}

void
disp_percentdone(percent)
int	percent;
{
    static int	lastpercent = 100;

    if (!Verbose)
	return;
    if (percent == 100)
    {
	printf("\r    \n");
	return;
    }
    if (percent != lastpercent && percent % 5 == 0)
    {
	printf("\r%2d%% ", percent);
	fflush(stdout);
	lastpercent = percent;
    }
}
