/*LINTLIBRARY*/

/*  @(#)news.c 1.8 89/12/11
 *
 *  C wrappers for News dependent graphics routines used by popi.
 *  written by Rich Burridge - Sun Microsystems Australia.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"
#include "graphics.h"
#include <sys/types.h>

/* Various pseudo events generated by the popi program. */
#define  KEYBOARD  100          /* Keyboard character was pressed. */
#define  REPAINT   101          /* Popi canvas needs repainting. */

extern FILE *PostScript ;
extern FILE *PostScriptInput ;

unsigned short icon_image[] = {
#include "popi.icon"
} ;


cleanup()            /* Null routine for the NeWS version. */
{
  FPRINTF(PostScript, "/destroy Frame send\n") ;
  FFLUSH(PostScript) ;
}


draw_scanline(line, y)      /* Display image scanline on the screen. */
unsigned char *line ;
int y ;
{
  int depth, i ;

  depth = (iscolor) ? 8 : 1 ;
  FPRINTF(PostScript, "/ScanLine %1d 1 %1d { } { < \n", Xsize, depth) ;
  if (iscolor)
    {
      for (i = 0; i < Xsize; i++)
        FPRINTF(PostScript, "%.2X ", line[i]) ;
    }
  else
    {
      mptr = (unsigned char *) Emalloc((Xsize / 8) + 1) ;
      halftone(line, y) ;
      for (i = 0; i < (Xsize / 8) + 1; i++)
        FPRINTF(PostScript, "%.2X ", 255 - mptr[i]) ;
    }
  FPRINTF(PostScript, "> } buildimage def\n") ;
  FPRINTF(PostScript, "%1d PSDrawScanLine\n", y) ;
  FFLUSH(PostScript) ;
}


drawarea(x, y, width, height, op)
int x, y, width, height ;
enum op_type op ;
{
  FPRINTF(PostScript, "%d %d %d %d %d PSDrawArea\n",
          x, y, width, height, (int) op) ;
  FFLUSH(PostScript) ;
}


drawline(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
  FPRINTF(PostScript, "%d %d %d %d PSDrawLine\n", x1, y1, x2, y2) ;
}


drawtext(x, y, fontno, str)
enum font_type fontno ;
int x, y ;
char *str ;
{
  int i ;
  char font, fonttype[6], line[MAXLINE] ;

       if (fontno == NFONT) STRCPY(fonttype, "NFont") ;
  else if (fontno == BFONT) STRCPY(fonttype, "BFont") ;
  line[0] = '\0' ;
  for (i = 0; i < strlen(str); i++)
    switch (str[i])
      {
        case '\\' : STRCAT(line,"\\\\") ;
                    break ;
        case '('  : STRCAT(line,"\\(") ;
                    break ;
        case ')'  : STRCAT(line,"\\)") ;
                    break ;
        default   : STRNCAT(line, &str[i], 1) ;
      }
  FPRINTF(PostScript, "%s %d %d (%s) PSDrawText\n", fonttype, x, y, line) ;
}


get_next_char(c)    /* Process events, and return when character is typed. */
char *c ;
{
  int ch, type ;

  for (;;)
    {
      FFLUSH(PostScript) ;
      if (pscanf(PostScriptInput, "%d", &type) == EOF) exit(0) ;
      switch (type)
        {
          case KEYBOARD : pscanf(PostScriptInput, "%d", &ch) ;
                          *c = ch ;
                          return ;
          case REPAINT  : paint_canvas() ;
        }
    }
/*NOTREACHED*/
}


init_fonts()
{
  FPRINTF(PostScript, "PSInitFonts\n") ;
  nfont_width = 9 ;
}


init_ws_type()
{
  if (ps_open_PostScript() < 0) return -1 ;
  if (send_ps_file(NEWSFILE) == -1)
    {
      FCLOSE(PostScript) ;
      return(-1) ;
    }
  FFLUSH(PostScript) ;
  if (ferror(PostScript))
    {
      FCLOSE(PostScript) ;
      return(-1) ;
    }
  FPRINTF(PostScript, "PSIsColor\n") ;
  pscanf(PostScriptInput, "%d", &iscolor) ;
  FPRINTF(PostScript, "PSInitialise\n") ;
  return(0) ;
}


load_colors()    /* Create and load popi color map. */
{
  int i ;
  u_char red[CMAPLEN], green[CMAPLEN], blue[CMAPLEN] ;

  for (i = 0; i < CMAPLEN; i++)
    red[i] = green[i] = blue[i] = 255 - i ;
 
  FPRINTF(PostScript, "%d PSMakeColorTable\n", 256) ;
  for (i = 0; i < 256; i++)
    FPRINTF(PostScript, "%d %d %d %d PSLoadColor\n",
                       red[i], green[i], blue[i], i) ;
}


make_icon()
{
  int i, j ;

  FPRINTF(PostScript,"/PopiIcon 64 64 1 { } { <\n") ;
  for (i = 0; i < 32; i++)
    {
      for (j = 0; j < 8; j++) FPRINTF(PostScript,"%.4X ", icon_image[i*8+j]) ;
      FPRINTF(PostScript,"\n") ;
    }
  FPRINTF(PostScript,"> } buildimage def\n") ;
}


make_items(argc, argv)       /* Create icon, frame, canvas etc.. */
int argc ;
char *argv[] ;
{
  make_icon() ;
  FPRINTF(PostScript, "%d %d %d %d %d %d %d PSMakeItems\n",
                     wx, wy, TWIDTH, THEIGHT,
                     ix, iy, iconic) ;
  load_colors() ;
}


send_ps_file(fname)
char *fname ;
{
  FILE *stream ;
  int c ;

  if ((stream = fopen(fname,"r")) == NULL) return -1 ;
  while ((c = getc(stream)) != EOF) PUTC(c, PostScript) ;
  FCLOSE(stream) ;
  return 0 ;
}


set_cursor(type)
enum cur_type type ;
{
  FPRINTF(PostScript, "%d PSSetCursor\n", (int) type) ;
}


start_tool()          /* Null routine in the NeWS version. */
{
}
