/*LINTLIBRARY*/

/*  @(#)sunview.c 1.10 89/12/11
 *
 *  SunView dependent graphics routines used by popi.
 *  written by Rich Burridge - Sun Microsystems.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#include "popi.h"
#include "graphics.h"
#include <suntool/sunview.h>
#include <suntool/canvas.h>

#define  ICON_SET                       (void) icon_set
#define  NOTIFY_DISPATCH                (void) notify_dispatch
#define  NOTIFY_DO_DISPATCH             (void) notify_do_dispatch
#define  NOTIFY_INTERPOSE_DESTROY_FUNC  (void) notify_interpose_destroy_func
#define  PR_GETCOLORMAP                 (void) pr_getcolormap
#define  PW_PUTCOLORMAP                 (void) pw_putcolormap
#define  PW_ROP                         (void) pw_rop
#define  PW_SETCMSNAME                  (void) pw_setcmsname
#define  PW_TEXT                        (void) pw_text
#define  PW_VECTOR                      (void) pw_vector
#define  PW_WRITEBACKGROUND             (void) pw_writebackground
#define  WINDOW_DONE                    (void) window_done
#define  WINDOW_SET                     (void) window_set

#define  BOLD_FONT      "/usr/lib/fonts/fixedwidthfonts/screen.b.14"
#define  NORMAL_FONT    "/usr/lib/fonts/fixedwidthfonts/screen.r.14"

Canvas canvas ;
Cursor busy_cursor, main_cursor ;
Event event ;
Frame frame ;
Icon popi_icon ;
Notify_value destroy_proc() ;
Pixfont *font, *nfont, *bfont ;
Pixrect *pr ;                       /* Offscreen image area. */
Pixwin *cpw ;

short busy_cursor_array[] = {
#include <images/hglass.cursor>
} ;
mpr_static(busy_cursor_pr, 16, 16, 1, busy_cursor_array) ;

unsigned short icon_image[] = {
#include "popi.icon"
} ;
mpr_static(icon_pr, 64, 64, 1, icon_image) ;

int blocking ;       /* Set if in event blocking mode. */
int gotevent ;       /* Set if we have an event to handle. */
int nonblocking ;    /* Set if in event non-blocking mode. */
int oktoshow ;       /* Set just before window is displayed. */


/*ARGSUSED*/
void
canvas_proc(canvas, e)
Canvas canvas ;
Event *e ;
{
  if (!oktoshow) return ;
  event = *e ;
  gotevent = 1 ;
  if (blocking) notify_stop() ;
}


cleanup()            /* Null routine for the SunView version. */
{
}


/*ARGSUSED*/
Notify_value
destroy_proc(client, status)
Notify_client client ;
Destroy_status status ;
{
  exit(0) ;
}


draw_scanline(line, y)       /* Display image scanline on the screen. */
unsigned char *line ;
int y ;
{
  int i ;

  mptr = (unsigned char *) ((struct mpr_data *) pr->pr_data)->md_image ;
  if (iscolor)
    for (i = 0; i < Xsize; i++) mptr[i] = 255 - line[i] ;
  else halftone(line, y) ;
  PW_ROP(cpw, 0, y+100, Xsize, 1, PIX_SRC, pr, 0, 0) ;
}


drawarea(x, y, width, height, op)
int x, y, width, height ;
enum op_type op ;
{
  PW_WRITEBACKGROUND(cpw, x, y, width, height, ops[(int) op]) ;
}


drawline(x1, y1, x2, y2)
int x1, y1, x2, y2 ;
{
  PW_VECTOR(cpw, x1, y1, x2, y2, PIX_SET, 0) ;
}


drawtext(x, y, fontno, str)
enum font_type fontno ;
int x, y ;
char *str ;
{
  if (fontno == NFONT) font = nfont ;
  else if (fontno == BFONT) font = bfont ;
  PW_TEXT(cpw, x, y, PIX_SRC, font, str) ;
}


Pixfont *
get_font(name)
char *name ;
{
  Pixfont *font ;

  font = pf_open(name) ;
  if (font == NULL) font = pf_default() ;
  if (font == NULL)
    {
      perror("couldn't get the default font.") ;
      exit(1) ;
    }
  return font ;
}


get_event()       /* Get the next SunView event. */
{
  if (!gotevent) notify_start() ;  /* This blocks until notify_stop. */
  gotevent = 0 ;
}


get_next_char(c)      /* Process events, and return when character typed. */
char *c ;
{
  for (;;)
    {
      get_event() ;
      if (event_is_ascii(&event))            /* Keyboard character? */
        {
          *c = event_id(&event) ;
          return ;
        }
      else window_default_event_proc(canvas, &event, (char *) 0) ;
    }
}


init_fonts()
{
  bfont = get_font(BOLD_FONT) ;
  nfont = get_font(NORMAL_FONT) ;
  nfont_width = nfont->pf_defaultsize.x ;
}


init_ws_type()
{
  if (getenv("WINDOW_PARENT") == NULL)
    {
      FPRINTF(stderr,"%s: Not a native SunView window\n", ProgName) ;
      return -1 ;
    }
  ops[(int) GCLR] = PIX_CLR ;
  ops[(int) GSET] = PIX_SET ;
  oktoshow = 0 ;        /* Kludge to correctly handle repaints. */
  blocking = 1 ;
  return 0 ;
}


load_colors()    /* Create and load popi color map. */
{
  int i ;
  char cmsname[MAXLINE] ;
  u_char red[CMAPLEN], green[CMAPLEN], blue[CMAPLEN] ;

  iscolor = (cpw->pw_pixrect->pr_depth == 8) ? 1 : 0 ;

  if (iscolor)
    {
      for (i = 0; i < CMAPLEN; i++)
        red[i] = green[i] = blue[i] = 255 - i ;

      SPRINTF(cmsname, "popi%10ld", getpid()) ;
      PW_SETCMSNAME(cpw, cmsname) ;
      PW_PUTCOLORMAP(cpw, 0, CMAPLEN, red, green, blue) ;

      pr = mem_create(Xsize, 1, 8) ;
    }
  else pr = mem_create(Xsize, 1, 1) ;
}


make_items(argc, argv)       /* Create icon, frame, canvas etc.. */
int argc ;
char *argv[] ;
{
  popi_icon = icon_create(ICON_IMAGE, &icon_pr, 0) ;
  frame = window_create((Window) 0, FRAME,
                        FRAME_ICON,       popi_icon,
                        FRAME_SHOW_LABEL, FALSE,
                        FRAME_NO_CONFIRM, TRUE,
                        FRAME_ARGS,       argc, argv,
                        0) ;
  canvas = window_create(frame, CANVAS,
                         WIN_WIDTH,      TWIDTH,
                         WIN_HEIGHT,     THEIGHT,
                         WIN_EVENT_PROC, canvas_proc,
                         0) ;
 
  WINDOW_SET(canvas, WIN_CONSUME_KBD_EVENTS, WIN_ASCII_EVENTS,
                     WIN_LEFT_KEYS, WIN_TOP_KEYS, WIN_RIGHT_KEYS,
                     WIN_UP_EVENTS, 0, 0) ;
  WINDOW_SET(canvas, WIN_IGNORE_PICK_EVENT, LOC_MOVE, 0) ;
  cpw = canvas_pixwin(canvas) ;

  main_cursor = window_get(canvas, WIN_CURSOR) ;
  busy_cursor = cursor_create(CURSOR_IMAGE, &busy_cursor_pr, 0) ;
  load_colors() ;            /* Load the popi grayscale colormap. */
}


set_cursor(type)
enum cur_type type ;
{
  switch (type)
    {
      case BUSY_CUR   : WINDOW_SET(canvas, WIN_CURSOR, busy_cursor, 0) ;
                        break ;
      case NORMAL_CUR : WINDOW_SET(canvas, WIN_CURSOR, main_cursor, 0) ;
    }
}


start_tool()
{
  window_fit(frame) ;
  NOTIFY_INTERPOSE_DESTROY_FUNC(frame, destroy_proc) ;
  oktoshow = 1 ;
  WINDOW_SET(frame, WIN_SHOW, TRUE, 0) ;
  NOTIFY_DISPATCH() ;      /* Make the window appear. */
  NOTIFY_DO_DISPATCH() ;
}
