/* pbmtorast.c - read a portable bitmap and produce a Sun rasterfile
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

/* Because of the following include, this program compiles only on Suns. */
#include <pixrect/pixrect_hs.h>

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int linebytes;
    int rows, cols, row, col;
    struct pixrect *pr;
    short *data;
    int shortcount, bitcount;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
	ifd = fopen( argv[1], "r" );
	if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    if ( (pr = mem_create(cols, rows, 1)) == NULL )
	{
	fprintf( stderr, "Unable to create new pixrect.\n");
	exit( 1 );
	}

    data = ((struct mpr_data *)pr->pr_data)->md_image;
    linebytes = ((struct mpr_data *)pr->pr_data)->md_linebytes;

    for ( row = 0; row < rows; row++ )
	{
	bitcount = 15;
	shortcount = 0;
	for ( col = 0; col < cols; col++ )
	    {
	    *(data + shortcount) |= (bits[row][col] << bitcount);
	    bitcount--;
	    if ( bitcount < 0 )
		{
		bitcount = 15;
		shortcount++;
		}
	    }
	data += linebytes / sizeof(short);
	}

    pr_dump( pr, stdout, NULL, RT_BYTE_ENCODED, 0 );

    exit( 0 );
    }
