/* pbmcrop.c - crop a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits, **newbits, background;
    int argn, backdefault, c;
    int rows, cols, row, col, newrows, newcols;
    int top, bottom, left, right;
    char *usage = "usage:  %s [-0]/[-w]/[-1]/[-b] [pbmfile]\n";

    argn = 1;
    backdefault = 1;

    /* Check for flags. */
    if ( argn < argc )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( ( argv[argn][1] == '0' || argv[argn][1] == 'w' ||
		   argv[argn][1] == 'W' ) && argv[argn][2] == '\0' )
		{
		backdefault = 0;
		background = 0;
		}
	    else if ( ( argv[argn][1] == '1' || argv[argn][1] == 'b' ||
			argv[argn][1] == 'B' ) && argv[argn][2] == '\0' )
		{
		backdefault = 0;
		background = 1;
		}
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    argn++;
	    }
	}

    if ( argn == argc )
	ifd = stdin;
    else
	{
        ifd = fopen( argv[argn], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[argn] );
	    exit( 1 );
	    }
	argn++;
	}
    bits = pbm_readpbm( ifd, &cols, &rows );
    if ( ifd != stdin )
	fclose( ifd );

    if ( argn != argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    if ( backdefault )
	{
	/* Guess what the background is by looking for an edge of
	** all one color.
	*/
	c = 0;
	for ( col = 0; col < cols; col++ )
	    c += bits[0][col];
	if ( c == 0 )
	    background = 0;
	else if ( c == cols )
	    background = 1;
	else
	    {
	    c = 0;
	    for ( col = 0; col < cols; col++ )
		c += bits[rows - 1][col];
	    if ( c == 0 )
		background = 0;
	    else if ( c == cols )
		background = 1;
	    else
		{
		c = 0;
		for ( row = 0; row < rows; row++ )
		    c += bits[row][0];
		if ( c == 0 )
		    background = 0;
		else if ( c == rows )
		    background = 1;
		else
		    {
		    c = 0;
		    for ( row = 0; row < rows; row++ )
			c += bits[row][cols - 1];
		    if ( c == 0 )
			background = 0;
		    else if ( c == rows )
			background = 1;
		    else
			{
			fprintf( stderr, "(nothing to crop, continuing)\n" );
			background = 0;		/* arbitrary */
			}
		    }
		}
	    }
	}

    /* Find first non-background line. */
    for ( top = 0; top < rows; top++ )
	for ( col = 0; col < cols; col++ )
	    if ( bits[top][col] != background )
		goto gottop;
gottop:

    /* Find last non-background line. */
    for ( bottom = rows - 1; bottom >= top; bottom-- )
	for ( col = 0; col < cols; col++ )
	    if ( bits[bottom][col] != background )
		goto gotbottom;
gotbottom:

    /* Find first non-background column. */
    for ( left = 0; left < cols; left++ )
	for ( row = top; row <= bottom; row++ )
	    if ( bits[row][left] != background )
		goto gotleft;
gotleft:

    /* Find last non-background column. */
    for ( right = cols - 1; right > left; right-- )
	for ( row = top; row <= bottom; row++ )
	    if ( bits[row][right] != background )
		goto gotright;
gotright:

    if ( top > 0 )
	fprintf( stderr, "(cropping %d %d-rows off the top)\n",
		 top, background );
    if ( bottom < rows - 1 )
	fprintf( stderr, "(cropping %d %d-rows off the bottom)\n",
		 rows - 1 - bottom, background );
    if ( left > 0 )
	fprintf( stderr, "(cropping %d %d-cols off the left)\n",
		 left, background );
    if ( right < cols - 1 )
	fprintf( stderr, "(cropping %d %d-cols off the right)\n",
		 cols - 1 - right, background );

    /* Now copy into a new array. */
    newcols = right - left + 1;
    newrows = bottom - top + 1;
    newbits = pbm_allocarray( newcols, newrows );
    for ( row = top; row <= bottom; row++ )
        for ( col = left; col <= right; col++ )
	    newbits[row-top][col-left] = bits[row][col];

    pbm_writepbm( stdout, newbits, newcols, newrows );

    exit( 0 );
    }
