/* libpbm2.c - pbm utility library part 2
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"
#include "libpbm.h"


static char
pbm_getc( file )
FILE *file;
    {
    int ich;
    char ch;

    ich = getc( file );
    if ( ich == NULL )
	{
	fprintf( stderr, "Premature EOF.\n" );
	exit( 1 );
	}
    ch = (char) ich;
    
    if ( ch == '#' )
	{
	do
	    {
	    ich = getc( file );
	    if ( ich == NULL )
		{
		fprintf( stderr, "Premature EOF.\n" );
		exit( 1 );
		}
	    ch = (char) ich;
	    }
	while ( ch != '\n' );
	}

    return ch;
    }

static int
pbm_getint( file )
FILE *file;
    {
    char ch;
    int i;

    do
	{
	ch = pbm_getc( file );
	}
    while ( ch == ' ' || ch == '\t' || ch == '\n' );

    if ( ch < '0' || ch > '9' )
	{
	fprintf( stderr, "Junk in file where an integer should be!\n" );
	exit( 1 );
	}

    i = 0;
    do
	{
	i = i * 10 + ch - '0';
	ch = pbm_getc( file );
        }
    while ( ch >= '0' && ch <= '9' );

    return i;
    }

static bit
pbm_getbit( file )
FILE *file;
    {
    char ch;

    do
	{
	ch = pbm_getc( file );
	}
    while ( ch == ' ' || ch == '\t' || ch == '\n' );

    if ( ch != '0' && ch != '1' )
	{
	fprintf( stderr, "Junk in file where bits should be!\n" );
	exit( 1 );
	}

    return ( ch == '1' ) ? 1 : 0;
    }


bit **
pbm_readpbm( file, colsP, rowsP )
FILE *file;
int *colsP, *rowsP;
    {
    int ich1, ich2;
    bit **bits;
    int row, col;

    /* Check for magic number. */
    ich1 = getc( file );
    if ( ich1 == NULL )
	{
	fprintf( stderr, "Premature EOF.\n" );
	exit( 1 );
	}
    ich2 = getc( file );
    if ( ich2 == NULL )
	{
	fprintf( stderr, "Premature EOF.\n" );
	exit( 1 );
	}
    if ( ich1 != PBM_MAGIC1 || ich2 != PBM_MAGIC2 )
	{
	fprintf( stderr, "Bad magic number - not a pbm file.\n" );
	exit( 1 );
	}

    /* Read size. */
    *colsP = pbm_getint( file );
    *rowsP = pbm_getint( file );

    bits = pbm_allocarray( *colsP, *rowsP );

    for ( row = 0; row < *rowsP; row++ )
        for ( col = 0; col < *colsP; col++ )
	    bits[row][col] = pbm_getbit( file );

    return bits;
    }
