/* pbmtolj.c - read a portable bitmap and produce a LaserJet bitmap file
**	
**	based on pbmtops.c
**
**	Michael Haberler HP Vienna mah@hpuviea.uucp
**				   mcvax!tuvie!mah
**	misfeatures: 
**		no positioning
**
** Copyright (C) 1988 by Jef Poskanzer and Michael Haberler.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV
#include "pbm.h"

int dpi = 75;
    
main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int argn, rows, cols, rucols, padright, row, col;
    char ch;
    char *usage = 
"usage:  %s [-r resolution] [pbmfile]\n\t\
resolution = [75|100|150|300] (dpi)\n";

    argn = 1;

    /* Check for flags. */
    if ( argc > argn )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( strcmp( argv[argn], "-r" ) == 0 )
		{
		if ( argc == argn + 1 )
		    {
		    fprintf( stderr, usage, argv[0] );
		    exit( 1 );
		    }
		if ( sscanf( argv[argn+1], "%d", &dpi ) != 1 )
		    {
		    fprintf( stderr, usage, argv[0] );
		    exit( 1 );
		    }
		argn += 2;
		}
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    }
	}

    if ( argc > argn + 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    if ( argc == argn + 1 )
	{
        ifd = fopen( argv[argn], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[argn] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );

    /* Round cols up to the nearest multiple of 8. */
    rucols = ( cols + 7 ) / 8;
    rucols = rucols * 8;
    padright = rucols - cols;

    putinit( );
    for ( row = 0; row < rows; row++ )
	{
	/* Transfer raster graphics */
 	printf("\033*b%dW",rucols/8);
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	for ( col = 0; col < padright; col++ )
	    putbit( 0 );
        }
    putrest( );

    exit( 0 );
    }


int item, bitsperitem, bitshift, itemsperline, firstitem;

putinit( )
    {
    /* Set raster graphics resolution */
    printf("\033*t%dR",dpi);

    /* Start raster graphics, relative adressing */
    printf("\033*r1A");

    itemsperline = 0;
    bitsperitem = 1;
    item = 0;
    bitshift = 7;
    firstitem = 1;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 8 ) {
	putitem( );
        bitshift = 7;
    }
    if ( b )
	item += 1 << bitshift;
    bitsperitem++;
    bitshift--;
    }

putrest( )
    {
    if ( bitsperitem > 1 )
	putitem( );

    /* end raster graphics */
    printf( "\033*rB" );
    }

putitem( )
    {
    putchar( item );
    bitsperitem = 0;
    item = 0;
    }
