/* pbmpaste.c - paste a rectangle into a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits1, **bits2;
    int argn, rows1, cols1, x, y, rows2, cols2, row, col;
    char function;
    char *usage = "usage:  %s [-r]/[-o]/[-a]/[-x] frompbmfile x y [intopbmfile]\n";

    argn = 1;
    function = 'r';

    /* Check for flags. */
    if ( argn < argc )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( ( argv[argn][1] == 'r' || argv[argn][1] == 'R' ||
		   argv[argn][1] == 'o' || argv[argn][1] == 'O' ||
		   argv[argn][1] == 'a' || argv[argn][1] == 'A' ||
		   argv[argn][1] == 'x' || argv[argn][1] == 'X' ) &&
		 argv[argn][2] == '\0' )
		function = argv[argn][1];
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    argn++;
	    }
	}

    if ( argn == argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    ifd = fopen( argv[argn], "r" );
    if ( ifd == NULL )
	{
	fprintf( stderr, "%s: can't open.\n", argv[argn] );
	exit( 1 );
	}
    bits1 = pbm_readpbm( ifd, &cols1, &rows1 );
    fclose( ifd );
    argn++;

    if ( argn == argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    if ( sscanf( argv[argn], "%d", &x ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    argn++;
    if ( argn == argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    if ( sscanf( argv[argn], "%d", &y ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    argn++;

    if ( x < 0 )
	{
	fprintf( stderr, "x is less than 0\n" );
	exit( 1 );
	}
    if ( y < 0 )
	{
	fprintf( stderr, "y is less than 0\n" );
	exit( 1 );
	}

    if ( argn == argc )
	ifd = stdin;
    else
	{
        ifd = fopen( argv[argn], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[argn] );
	    exit( 1 );
	    }
	argn++;
	}
    bits2 = pbm_readpbm( ifd, &cols2, &rows2 );
    if ( ifd != stdin )
	fclose( ifd );

    if ( x >= cols2 )
	{
	fprintf(
	    stderr, "x is too large -- the second bitmap has only %d cols\n",
	    cols2 );
	exit( 1 );
	}
    if ( y >= rows2 )
	{
	fprintf(
	    stderr, "y is too large -- the second bitmap has only %d rows\n",
	    rows2 );
	exit( 1 );
	}
    if ( x + cols1 > cols2 )
	{
	fprintf(
	    stderr, "x + width is too large by %d pixels\n",
	    x + cols1 - cols2 );
	exit( 1 );
	}
    if ( y + rows1 > rows2 )
	{
	fprintf(
	    stderr, "y + height is too large by %d pixels\n",
	    y + rows1 - rows2 );
	exit( 1 );
	}

    if ( argn != argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    for ( row = 0; row < rows1; row++ )
        for ( col = 0; col < cols1; col++ )
	    switch ( function )
		{
		case 'r':
		case 'R':
		bits2[row+y][col+x] = bits1[row][col];
		break;

		case 'o':
		case 'O':
		bits2[row+y][col+x] |= bits1[row][col];
		break;

		case 'a':
		case 'A':
		bits2[row+y][col+x] &= bits1[row][col];
		break;

		case 'x':
		case 'X':
		bits2[row+y][col+x] ^= bits1[row][col];
		break;
		}

    pbm_writepbm( stdout, bits2, cols2, rows2 );

    exit( 0 );
    }
