/* libpbm4.c - pbm utility library part 4
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"
#include "libpbm.h"


static int version, item, bitsinitem, bitshift;
static int bitspercount, count, repeatbits, repeatindex;
static bit repeat, repeatbuf[MAX_REPEATBITS];
static FILE *cbm_file;


static
cbm_getinit( file, colsP, rowsP )
FILE *file;
int *colsP, *rowsP;
    {
    int magic2;

    if ( getc( file ) != CBM_MAGIC1 )
	{
	fprintf( stderr, "Bad first magic number.\n" );
	exit( 1 );
	}
    if ( ( magic2 = getc( file ) ) != OCBM_MAGIC2 && magic2 != NCBM_MAGIC2 )
	{
	fprintf( stderr, "Bad second magic number.\n" );
	exit( 1 );
	}

    if ( magic2 == OCBM_MAGIC2 )
	version = VERSION_OLDCBM;
    else
	{
	version = getc( file );
	switch ( version )
	    {
	    case VERSION_RUNLEN:
	    bitspercount = getc( file );
	    repeatbits = getc( file );
	    count = 0;
	    break;

	    default:
	    fprintf( stderr, "Unknown cbm version %d.\n", version );
	    exit( 1 );
	    }
	}

    *colsP = getc( file ) << 8;
    *colsP += getc( file );
    *rowsP = getc( file ) << 8;
    *rowsP += getc( file );

    bitsinitem = 8;
    cbm_file = file;
    }

static bit
cbm_getbit( )
    {
    bit b;

    if ( bitsinitem == 8 )
	{
	item = getc( cbm_file );
	bitsinitem = 0;
	bitshift = 7;
	}
    bitsinitem++;
    b = ( item >> bitshift) & 1;
    bitshift--;
    return b;
    }

static bit
cbm_getrlbit( )
    {
    int i;

    if ( count == 0 )
	{
	repeat = cbm_getbit( );

	for ( i = 0; i < bitspercount; i++ )
	    count = ( count << 1 ) + cbm_getbit( );
	if ( count == 0 )
	    {
	    fprintf( stderr, "Error - zero count in cbm file.\n" );
	    exit( 1 );
	    }

	if ( repeat )
	    {
	    for ( i = 0; i < repeatbits; i++ )
		repeatbuf[i] = cbm_getbit( );
	    repeatindex = repeatbits - 1;
	    }
	}

    count--;
    if ( repeat )
	{
	repeatindex = ( repeatindex + 1 ) % repeatbits;
	return repeatbuf[repeatindex];
	}
    else
	return cbm_getbit( );
    }

bit **
pbm_readcbm( file, colsP, rowsP )
FILE *file;
int *colsP, *rowsP;
    {
    bit **bits;
    int row, col;

    cbm_getinit( file, colsP, rowsP );

    bits = pbm_allocarray( *colsP, *rowsP );

    switch ( version )
	{
	case VERSION_OLDCBM:
	for ( row = 0; row < *rowsP; row++ )
	    for ( col = 0; col < *colsP; col++ )
		bits[row][col] = cbm_getbit( );
	break;

	case VERSION_RUNLEN:
	for ( row = 0; row < *rowsP; row++ )
	    for ( col = 0; col < *colsP; col++ )
		bits[row][col] = cbm_getrlbit( );
	break;
	}

    return bits;
    }
