/***********************************************************************
 * $Author: markv $
 * $Revision: 1.3 $
 * $Date: 88/10/04 14:33:37 $
 * $Log:	screen.c,v $
 * Revision 1.3  88/10/04  14:33:37  markv
 * Revamped most of this code.  Added code for no antialiasing, jittering, 
 * filtered, and statistically optimized antialiasing.   Statistically
 * optimized anti aliasing still doesn't work properly.
 * 
 * Revision 1.2  88/09/12  10:00:54  markv
 * Fixed lingering (possible) bug with curbuf memory allocation.  
 * Size returned by malloc is now correct in both spots.
 * Thanks tim@ben.
 * 
 * Revision 1.1  88/09/11  11:00:43  markv
 * Initial revision
 * 
 ***********************************************************************/

#include <stdio.h>
#include <math.h>
#include <assert.h>
#include "defs.h"
#include "pic.h"
#include "extern.h"

Screen(view, picfile, xres, yres)
 Viewpoint *view ;
 char *picfile ;
 int xres, yres ;
{
	Pixel 	*buf, *oldbuf, *curbuf, *tmp ;
	Pic  	*pic, *PicOpen();
	Point 	viewvec, leftvec, upvec ;
	int red, green, blue ;
	Point	dir ;
	Ray 	ray ;
	Color	color;
	Flt	frustrumwidth ;
	int 	x, y ;

	pic = PicOpen(picfile, xres, yres) ;

	/*
	 * calculate the "up" vector...
	 */

	VecCopy(view -> view_up, upvec) ;
	VecNormalize(upvec) ;

	/*
	 * and the "view" vector....
	 */

	VecSub(view -> view_at, view-> view_from, viewvec);
	VecNormalize(viewvec);

	/*
	 * And the "left" vector...
	 */

	VecCross(view -> view_up, viewvec, leftvec);
	VecNormalize(leftvec);

	/*
	 * Calculate the width of the view frustrum in world coordinates.
	 * and then scale the left and up vectors appropriately.
	 */

	frustrumwidth = (view -> view_dist) * ((Flt) tan(view -> view_angle)) ;
	VecScale(-frustrumwidth, upvec) ;
	VecScale(-frustrumwidth, leftvec) ;

	if (filtflag) {
		FilterScan( pic,
			view -> view_from,
			viewvec,
			upvec,
			leftvec, 
			xres, yres) ;
	} else if (jitterflag) {
		JitterScan(   pic,
			view -> view_from,
			viewvec,
			upvec,
			leftvec, 
		 	xres, yres) ;
	} else {
		Scan(   pic,
			view -> view_from,
			viewvec,
			upvec,
			leftvec, 
		 	xres, yres) ;
	}

	PicClose(pic) ;
}




Scan(pic, eye, viewvec, upvec, leftvec, xres, yres)
 Pic * pic ;
 Vec eye ;
 Vec viewvec ;
 Vec upvec ;
 Vec leftvec ;
 int xres, yres ;
{
	Ray ray ;
	int x, y ;
	Flt xlen, ylen ;
	Color color ;

	/*
	 * Generate the image...
	 */

	VecCopy(eye, ray.P) ;
	for (y = 0 ; y < yres ; y++) {
		for (x = 0 ; x < xres ; x++) {
			xlen = ((Flt) (2 * x) / (Flt) xres) - 1.0 ;
			ylen = ((Flt) (2 * y) / (Flt) yres) - 1.0 ;
			VecComb(xlen, leftvec, ylen, upvec, ray.D) ;
			VecAdd(ray.D, viewvec, ray.D) ;
			VecNormalize(ray.D);
			Trace(0, 1.0, &ray, color);
			color[0] = min(1.0, color[0]) ;
			color[1] = min(1.0, color[1]) ;
			color[2] = min(1.0, color[2]) ;
			PicWritePixel(pic, color) ;
		}
		if (tickflag)
			fprintf(stderr, ".") ;
	}
	if (tickflag)
		fprintf(stderr, "\n") ;
}

FilterScan(pic, eye, viewvec, upvec, leftvec, xres, yres)
 Pic * pic ;
 Vec eye ;
 Vec viewvec ;
 Vec upvec ;
 Vec leftvec ;
 int xres, yres ;
{
	Ray ray ;
	int x, y, i ;
	Flt xlen, ylen ;
	Color color ;
	Color * nbuf, *obuf, *tmp  ;	/* new and old buffers, resp.	*/
	Color avg ;

	/*
	 * allocate enough memory for the filter buffer
	 */

	nbuf = (Color *) calloc ((xres + 1), sizeof(Color)) ;
	obuf = NULL ;

	VecCopy(eye, ray.P) ;

	for (y = 0 ; y <= yres ; y++) {
		for (x = 0 ; x <= xres ; x++) {
			xlen = ((Flt) (2 * x) / (Flt) xres) - 1.0 ;
			ylen = ((Flt) (2 * y) / (Flt) yres) - 1.0 ;
			VecComb(xlen, leftvec, ylen, upvec, ray.D) ;
			VecAdd(ray.D, viewvec, ray.D) ;
			VecNormalize(ray.D);
			Trace(0, 1.0, &ray, color);
			color[0] = min(1.0, color[0]) ;
			color[1] = min(1.0, color[1]) ;
			color[2] = min(1.0, color[2]) ;
			VecCopy(color, nbuf[x]) ;
		}
		if (obuf) {
			for (i = 0 ; i < xres ; i++) {
				VecAdd(nbuf[i], nbuf[i+1], avg) ;
				VecAdd(obuf[i], avg, avg) ;
				VecAdd(obuf[i+1], avg, avg) ;
				VecScale(0.25, avg) ;
				PicWritePixel(pic, avg) ;
			}
			tmp = obuf ;
			obuf = nbuf ;
			nbuf = tmp ;
		} else {
			/* 
			 * first scan line, set it up wierdly...
			 */
			obuf = nbuf ;
			nbuf = (Color *) calloc ((xres + 1), sizeof(Color)) ;
		}
		if (tickflag)
			fprintf(stderr, ".") ;
	}
	if (tickflag)
		fprintf(stderr, "\n") ;
}

JitterScan(pic, eye, viewvec, upvec, leftvec, xres, yres)
 Pic * pic ;
 Vec eye ; 
 Vec viewvec ; 
 Vec upvec ; 
 Vec leftvec ;
 int xres, yres ;
{
	Ray ray ;
	int x, y, i ;
	Flt xlen, ylen ;
	Flt xwidth, ywidth ;
	Color color, avg ;

	/*
	 * Generate the image...
	 */

	xwidth = 2.0 / (Flt) xres ;
	ywidth = 2.0 / (Flt) xres ;

	VecCopy(eye, ray.P) ;
	for (y = 0 ; y < yres ; y++) {
		ylen = ((Flt) (2 * y) / (Flt) yres) - 1.0 ;
		for (x = 0 ; x < xres ; x++) {
			xlen = ((Flt) (2 * x) / (Flt) xres) - 1.0 ;

			avg[0] = avg[1] = avg[2] = 0.0 ;

			for (i = 0 ; i < maxsamples ; i++) {
				VecComb(xlen + rnd() * xwidth, leftvec, 
					ylen + rnd() * ywidth, upvec, ray.D) ;
				VecAdd(ray.D, viewvec, ray.D) ;
				VecNormalize(ray.D);
				Trace(0, 1.0, &ray, color);
				VecAdd(color, avg, avg) ;
			}

			VecScale(1.0 / (Flt) maxsamples, avg) ;
			avg[0] = min(1.0, avg[0]) ;
			avg[1] = min(1.0, avg[1]) ;
			avg[2] = min(1.0, avg[2]) ;
			PicWritePixel(pic, avg) ;
		}
		if (tickflag)
			fprintf(stderr, ".") ;
	}
	if (tickflag)
		fprintf(stderr, "\n") ;
}
