/***********************************************************************
 * $Author: markv $
 * $Revision: 1.2 $
 * $Date: 88/10/04 14:30:44 $
 * $Log:	pic.c,v $
 * Revision 1.2  88/10/04  14:30:44  markv
 * Changed pixel writing primitives to write individual pixels rather
 * than scanlines.  Simplifies certain loops inside Screen.
 * 
 * Revision 1.1  88/09/11  11:00:41  markv
 * Initial revision
 * 
 ***********************************************************************/

#include <stdio.h>
#include "pic.h"
#include "defs.h"
#include "extern.h"

/*======================================================================*/
/* PIC.C								*/
/*                                                                      */
/* Simple routines for outputting a pixel map....                       */
/*                                                                      */
/* Mark VandeWettering, markv@cs.uoregon.edu                            */
/*======================================================================*/

Pic *
PicOpen(filename,x,y)
 char *filename ;
{
	Pic	*tmp ;

	tmp = (Pic *) malloc(sizeof (Pic)) ;
	tmp -> filename = (char *) malloc (strlen(filename)+1) ;
	strcpy(tmp->filename, filename);

	if (((tmp -> filep)=fopen(filename, "w"))==NULL) {
		perror( filename );
		exit( 1 );
	}

	tmp -> x = x ; tmp -> y = y ;

	fprintf(tmp -> filep, "%d %d\n", x, y);

	return(tmp);
}

PicWritePixel(pic, color)
 Pic *pic ;
 Color color ;
{
	fputc((unsigned char) (255.0 * color[0]), pic -> filep) ;
	fputc((unsigned char) (255.0 * color[1]), pic -> filep) ;
	fputc((unsigned char) (255.0 * color[2]), pic -> filep) ;
}

PicClose(pic)
 Pic *pic ;
{
	fclose(pic -> filep) ;
}
