%{
#include <stdio.h>
#include <math.h>
#include "defs.h"
#include "extern.h"

extern char yytext[] ;
extern FILE * yyin ;
Vec * pl, * plist ;
%}

%token VIEWPOINT FROM AT UP ANGLE HITHER RESOLUTION LIGHT
%token BACKGROUND SURFACE CONE SPHERE POLYGON PATCH NUM TOKEN

%union {
	Vec	vec ;
	Vec *	vecl ;
	double	flt ;
	Object * obj ;
} ;

%type <vec>	point primcolor TOKEN
%type <obj>	cone sphere polygon ppatch
%type <flt>	num 

%%

scene:
	camera elementlist 
	{
		int i, l ;
		for (l = 0 ; l < nLights ; l++) {
			Lights[l].light_brightness =  sqrt((Flt) nLights) / 
							((Flt)nLights) ;
			for (i = 0 ; i < MAXLEVEL ; i++) {
				Lights[l].light_obj_cache[i] = NULL ;
			}
		}
	} ;

elementlist:
	elementlist element
	|  ;

element:
	light
	| background
	| surface
	| object 
	{
		char buf[80] ;
		if (nPrims >= MAXPRIMS) {
			sprintf(buf, "max objects = %d", MAXPRIMS) ;
			yyerror(buf) ;
		}
	}	;

object:	  cone
	| sphere
	| polygon
	| ppatch ;

camera:
	VIEWPOINT			/* $1      */
	FROM point			/* $2-$3   */
	AT point			/* $4-$5   */
	UP point			/* $6-$7   */
	ANGLE num 			/* $8-$9   */
	HITHER num			/* $10-$11 */
	RESOLUTION num num		/* $12-$14 */
	{
		VecCopy($3, Eye.view_from) ;
		VecCopy($5, Eye.view_at) ;
		VecCopy($7, Eye.view_up) ;
		Eye.view_angle = degtorad($9/2.0 ) ;
		Eye.view_dist = $11 ;
		if (resolutionflag > 0) {
			/* ignore the specified resolution... */
			Xresolution = Yresolution = resolutionflag ;
		} else {
			Xresolution = (int) $13 ;
			Yresolution = (int) $14 ;
		}
	} ;

light:
	LIGHT point 
	{
		VecCopy($2, Lights[nLights].light_pos) ;
		/* fill in brightness of the light, after we 
		 * know the number of lights sources in the scene
		 */
		nLights ++ ;
	} ;

background:
	BACKGROUND primcolor
	{
		VecCopy($2, BackgroundColor) ;
	} ;

surface:
	SURFACE primcolor num num num num num 
	{
		CurrentSurface = (Surface *) malloc (sizeof(Surface)) ;
		VecCopy($2, CurrentSurface -> surf_color) ;
		CurrentSurface -> surf_kd = $3 ;
		CurrentSurface -> surf_ks = $4 ;
		CurrentSurface -> surf_shine = $5 ;
		CurrentSurface -> surf_kt = $6 ;
		CurrentSurface -> surf_ior = $7 ;
	} ;

cone:
	CONE point num point num 
	{
		$$ = MakeCone($2, $3, $4, $5) ;
		Prims[nPrims++] = $$ ;

	} ;
sphere:
	SPHERE point num 
	{
		$$ = MakeSphere($2, $3) ;
		Prims[nPrims++] = $$ ;
	} ;

polygon:
	POLYGON num 
	{
		plist = (Vec *) calloc((int) $2, sizeof(Vec)) ;
		pl = plist ;
	} 
	pointlist 
	{
		$$ = MakePoly((int) $2, plist) ;
		Prims[nPrims++] = $$ ;
	} ;
ppatch:
	PATCH num
        {
		if ((int) $2 != 3)
			fprintf(stderr, "patches must have 3 vertices...\n") ;
		plist = (Vec *) calloc(2 * (int) $2, sizeof(Vec)) ;
		pl = plist ;
	}
	pointlist
	{
		$$ = MakeTri(plist) ;
		Prims[nPrims++] = $$ ;
	} ;

primcolor:
	num num num 
	{
		$$[0] = $1 ;
		$$[1] = $2 ;
		$$[2] = $3 ;
	}  
	| TOKEN
	{
		char buf[80] ;

		if (LookupColorByName(yytext, $$) == 0) {
			sprintf(buf, "cannot find color \"%s\"\n",
				yytext) ;
			yyerror(buf) ;
		}
	} ;

point:
	num num num
	{
		$$[0] = $1 ;
		$$[1] = $2 ;
		$$[2] = $3 ;
	} ;

pointlist:
	pointlist point
	{
		VecCopy($2, (*pl)) ;
		pl ++ ;
	} 
	| ;

num:
	NUM
		{
			$$ = atof(yytext) ;
		} ;

%%

yyerror(str)
 char * str ;
{
	fprintf(stderr, "%s: error at line %d\n", 
		Progname, yylinecount) ;
	fprintf(stderr, "%s: %s\n", Progname, str) ;
	exit(-1) ;
}

ReadSceneFile(str)
 char *str ;
{
	if (str == NULL) 
		yyin = stdin ;
	else {
		if ((yyin = fopen(str, "r")) == NULL) {
			fprintf(stderr, "%s: cannot open %s\n", Progname,
						str) ;
			exit(-1) ;
		}
	}
	if (yyparse() == 1) {
		fprintf(stderr, "%s: invalid input specification\n", Progname);
		exit(-1) ;
	}
	fprintf(stderr, "%s: %d prims, %d lights\n", 
			Progname, nPrims, nLights) ;
	fprintf(stderr, "%s: inputfile = \"%s\"\n", Progname, str) ;
	fprintf(stderr, "%s: resolution %dx%d\n", Progname, Xresolution,
		Yresolution) ;
}
