/***********************************************************************
 * $Author: markv $
 * $Revision: 1.6 $
 * $Date: 88/10/31 14:33:44 $
 * $Log:	main.c,v $
 * Revision 1.6  88/10/31  14:33:44  markv
 * Removed non-functioning antialiasing...
 * 
 * Revision 1.5  88/10/04  14:29:16  markv
 * Added flags having to do with antialiasing, both statistically
 * optimized and jittered.
 * 
 * Revision 1.4  88/09/13  16:08:21  markv
 * Moved InitSlabs, must occur before ReadSceneFile
 * 
 * Revision 1.3  88/09/13  16:05:44  markv
 * Usage message now prints -t flag as well.
 * 
 * Revision 1.2  88/09/12  12:53:11  markv
 * Added printout of new statistic on shadow cache hits.
 * 
 * Revision 1.1  88/09/11  11:02:23  markv
 * Initial revision
 * 
 ***********************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/times.h>
#include "defs.h"
#include "extern.h"

main(argc, argv)
 int argc ;
 char * argv[] ;
{
	extern int optind ;
	extern char *optarg ;
	int c ;
	char * infilename = NULL ;
	char * outfilename = "out.pic" ;
	struct tms pbuf, tbuf ;

	if ((Progname = rindex(argv[0], '/')) == NULL) 
		Progname = argv[0] ;
	else 
		Progname ++ ;

	while ((c = getopt(argc, argv, "r:a:o:i:tfj:")) != EOF) {
		switch (c) {
		case 'r':
			resolutionflag = atoi(optarg) ;
			break ;
		case 'f':
			filtflag = 1 ;
			break ;
		case 'j':
			jitterflag = 1 ;
			maxsamples = atoi(optarg) ;
			if (maxsamples <= 0) {
				fprintf(stderr, "%s: samples must be > 0\n",
					Progname) ;
				exit(1) ;
			}
			break ;
		case 'o':
			outfilename = optarg ;
			break ;
		case 'i':
			infilename = optarg ;
			break ;
		case 't':
			tickflag = 1 ;
			break ;
		case '?':
			fprintf(stderr, "usage: %s [-i file] [-o file] [-t]\n",
				Progname) ;
			exit(-1);
		}
	}

	InitSlabs() ;			/* Normalizes slab normals...	*/
	ReadSceneFile(infilename) ;
	if (resolutionflag > 0) {
		Xresolution = Yresolution = resolutionflag ;
	}
	BuildBoundingSlabs() ;
	times(&pbuf) ;
	Screen(&Eye, outfilename, Xresolution, Yresolution) ;
	times(&tbuf) ;
	tbuf.tms_utime -= pbuf.tms_utime ;
	tbuf.tms_stime -= pbuf.tms_stime ;
	PrintStatistics(&pbuf, &tbuf) ;
}

PrintStatistics(pbuf, tbuf)
 struct tms *pbuf, *tbuf ;
{

	printf("preprocess time (user code)	%-6d seconds\n",
			pbuf -> tms_utime / 60) ;
	printf("preprocess time (system code)	%-6d seconds\n",
			pbuf -> tms_stime / 60) ;
	printf("tracing time (user code)	%-6d seconds\n",
			tbuf -> tms_utime / 60 ) ;
	printf("tracing time (system code)	%-6d seconds\n",
			tbuf -> tms_stime / 60 ) ;

	printf("number of rays cast:	   %-6d\n", nRays);
	printf("number of shadow rays:	   %-6d\n", nShadows);
	printf("number of reflected rays:  %-6d\n", nReflected);
	printf("number of refracted rays:  %-6d\n", nRefracted);

	printf("number of queue inserts:   %-6d\n", totalQueues) ;
	printf("number of queue resets:    %-6d\n", totalQueueResets) ;
	printf("avg number of queues/ray:  %-6g\n", (Flt) totalQueues /
						(Flt) totalQueueResets) ;
	printf("max queue size:		   %-6d\n", maxQueueSize) ;
	printf("number of bound checks:	   %-6d\n", nChecked) ;
	printf("number of bound queued:	   %-6d\n", nEnqueued) ;
	printf("number of shadow hits:	   %-6d\n", nShadowCacheHits) ;
}
