/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"


#define MAX_DEC		50


extern table_st *copy_of_table ();


static struct declare_st {
    char *name;
    table_st *table;
} dec [ MAX_DEC ];

static int num_dec;



pdef_tab ()
{
    return;
}



tab_declare ( name , table )
char *name;
table_st *table;
{
    int i;

    for ( i = 0; i < num_dec; i++ ) {
	if ( strcmp ( name , dec[i].name ) == 0 ) {
	    free_table ( dec[i].table );
	    dec[i].table = table;
	    return;
	}
    }
    if ( num_dec >= MAX_DEC )
	abort ( "Internal array overflow - too many tables declared" );
    dec[num_dec].name = name;
    dec[num_dec].table = table;
    num_dec++;
}




table_st *
tab_lookup ( name )
char *name;
{
    int i , cols;
    table_st *table , *ftp , *ttp , *p;

    for ( i = 0; i < num_dec; i++ ) {
	if ( strcmp ( dec[i].name , name ) == 0 ) {
	    return ( copy_of_table ( dec[i].table ) );
	}
    }
    abort ( "Undefined table '%s' referenced" , name );
    return ( NULL );
}



is_tab_ident ( name )
char *name;
{
    int i;

    for ( i = 0; i < num_dec; i++ ) {
	if ( strcmp ( dec[i].name , name ) == 0 ) {
	    return ( 1 );
	}
    }
    return ( 0 );
}


