/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"


extern struct table_st *new_table ();


save_table ( filename , table )
char *filename;
table_st *table;
{
    table_st *p;
    int i;
    int cols;
    FILE *fp;


    if ( filename == NULL ) {
	fp = stdout;
	filename = "stdout";
    }
    else {
	fp = fopen ( filename , "w" );
	if ( fp == NULL )
	    abort ( "failed to open save file '%s'" , filename );
    }
    if ( table == NULL ) {
	outint ( fp , 0 , filename );	/* cols */
	outint ( fp , 0 , filename );	/* rows */
    }
    else {
	cols = num_cols ( table );
	outint ( fp , cols );
	outint ( fp , table->size );
	for ( p = table; p != NULL; p = p->next )
	    if ( fwrite ( p->data , sizeof ( double ) , p->size , fp ) != p->size )
		abort ( "Write error on '%s'" , filename );
    }
    if ( fp != stdout )
	fclose ( fp );
}


outint ( fp , val , filename )
FILE *fp;
int val;
char *filename;
{
    if ( fwrite ( &val , sizeof ( val ) , 1 , fp ) != 1 )
	abort ( "Error when writing to '%s'" , filename );
}



struct table_st *
load_table ( filename )
char *filename;
{
    FILE *fp;
    struct table_st *p , *tab;
    int cols , rows;

    if ( filename == NULL ) {
	fp = stdin;
	filename = "stdin";
    }
    else {
	fp = fopen ( filename , "r" );
	if ( fp == NULL )
	    abort ( "failed to open file '%s' to load it" , filename );
    }
    if ( fread ( &cols , sizeof ( int ) , 1 , fp ) != 1 )
	abort ( "Error when reading '%s'" , filename );
    if ( fread ( &rows , sizeof ( int ) , 1 , fp ) != 1 )
	abort ( "Error when reading '%s'" , filename );
    tab = new_table ( cols , rows );
    for ( p = tab; p != NULL; p = p->next ) {
	if ( fread ( p->data , sizeof ( double ) , p->size , fp ) != p->size )
	    abort ( "Read error on '%s' when loading file" , filename );
    }
    if ( fp != stdin )
	fclose ( fp );
    return ( tab );
}
