/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"


extern double eval ();



print_table ( table , filename , mode )
table_st *table;
char *filename , *mode;
{
    table_st *p;
    int i;
    int cols;
    FILE *fp;


    if ( filename == NULL )
	fp = stdout;
    else {
	fp = fopen ( filename , mode );
	if ( fp == NULL )
	    abort ( "failed to open print file '%s'" , filename );
    }
    if ( table == NULL ) {
	fprintf ( fp , "empty table\n" );
    }
    else {
	cols = 0;
	for ( p = table; p != NULL; p = p->next )
	    cols++;
	for ( i = 0; i < table->size; i++ ) {
	    for ( p = table; p != NULL; p = p->next ) {
		fprintf ( fp , "%g" , p->data[i] );
		if ( p->next != NULL )
		    fprintf ( fp , "\t" );
	    }
	    fprintf ( fp , "\n" );
	}
    }
    if ( fp != stdout )
	fclose ( fp );
}



print_expr ( value , filename , mode )
double value;
char *filename , *mode;
{
    FILE *fp;

    if ( filename == NULL )
	fp = stdout;
    else {
	fp = fopen ( filename , mode );
	if ( fp == NULL )
	    abort ( "failed to open print file '%s'" , filename );
    }
    fprintf ( fp , "%g\n" , value );
    if ( fp != stdout )
	fclose ( fp );
}



print_string ( string , filename , mode )
char *string;
char *filename , *mode;
{
    FILE *fp;

    if ( filename == NULL )
	fp = stdout;
    else {
	fp = fopen ( filename , mode );
	if ( fp == NULL )
	    abort ( "failed to open print file '%s'" , filename );
    }
    fprintf ( fp , "%s\n" , string );
    if ( fp != stdout )
	fclose ( fp );
}

