/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include <signal.h>
#include "graph.h"
#include "y.tab.h"

/* if not on cc line, use default */
#ifndef GLOB_LIB
#define GLOB_LIB "/usr/lib/graph+rc"
#endif


extern char *getenv ();


extern char *PROG_NAME;
extern int gargc;
extern char **gargv;
extern char *infilename;
extern int linenum;
extern axis_st xaxis;
extern axis_st yaxis;
extern int warnings;
extern FILE *yyin;
extern int horiz_legend;
extern int vert_legend;
extern int num_graphs;


main ( argc , argv )
int argc;
char **argv;
{
    int float_exception ();

    char *home;
    char buf[200];
    FILE *fp;
    int read_stdin;


    signal ( SIGFPE , float_exception );
    if ( argc < 1 ) {
	fprintf ( stderr , "usage: %s [ commandfile | - ] [ parameter ... ]\n" , PROG_NAME );
	exit ( 1 );
    }

    warnings = 1;	/* should be an option */

    num_graphs = 0;
    horiz_legend = RIGHT;
    vert_legend = TOP;

    xaxis.format = yaxis.format = "%.1f";
    xaxis.user_format = yaxis.user_format = NULL;
    xaxis.label = yaxis.label = "";
    xaxis.scale = yaxis.scale = AUTO;
    xaxis.frame = yaxis.frame = GRID;
    xaxis.linear = yaxis.linear = LINEAR;
    xaxis.auto_tick_size = yaxis.auto_tick_size = 1;
    xaxis.range.min = yaxis.range.min = 0.0;
    xaxis.range.max = yaxis.range.max = -1.0;
    xaxis.interval = yaxis.interval = NULL;

    pdef_fun ();
    pdef_var ();
    pdef_tab ();

    if ( ( fp = fopen ( GLOB_LIB , "r" ) ) != NULL ) {
	yyin = fp;
	linenum = 1;
	infilename = GLOB_LIB;
	yyparse ();
	fclose ( yyin );
    }

    if ( ( home = getenv ( "HOME" ) ) != NULL ) {
	sprintf ( buf , "%s/.graph+rc" , home );
	if ( ( fp = fopen ( buf , "r" ) ) != NULL ) {
	    yyin = fp;
	    linenum = 1;
	    infilename = buf;
	    yyparse ();
	    fclose ( yyin );
	}
    }

    read_stdin = ( argc < 2  ||  strcmp ( argv[1] , "-" ) == 0 );

    gargc = argc;
    gargv = argv;

    if ( ! read_stdin ) {
	if ( ( fp = fopen ( argv[1] , "r" ) ) == NULL ) {
	    fprintf ( stderr , "%s: failed to open command file '%s'\n" ,
		PROG_NAME , argv[1] );
	    exit ( 1 );
	}
	yyin = fp;
	infilename = argv[1];
	linenum = 1;
    }
    else {
	yyin = stdin;
	infilename = "stdin";
	linenum = 1;
    }

    yyparse ();

}


/* FOR VAX-11 ONLY - well, our vax anyway */

float_exception ( sig , code )
int sig , code;
{
    switch ( code ) {

#ifdef FPE_INTOVF_TRAP 
    case FPE_INTOVF_TRAP : abort ( "Integer overflow trap" );
#endif
#ifdef FPE_INTDIV_TRAP 
    case FPE_INTDIV_TRAP : abort ( "Integer division by zero trap" );
#endif
#ifdef FPE_FLTOVF_TRAP 
    case FPE_FLTOVF_TRAP : abort ( "Floating point overflow trap" );
#endif
#ifdef FPE_FLTDIV_TRAP 
    case FPE_FLTDIV_TRAP : abort ( "Floating/decimal division by zero trap" );
#endif
#ifdef FPE_FLTUND_TRAP 
    case FPE_FLTUND_TRAP : abort ( "Floating underflow trap" );
#endif
#ifdef FPE_DECOVF_TRAP 
    case FPE_DECOVF_TRAP : abort ( "Decimal overflow trap" );
#endif
#ifdef FPE_SUBRNG_TRAP 
    case FPE_SUBRNG_TRAP : abort ( "Subscript range trap" );
#endif
#ifdef FPE_FLTOVF_FAULT
    case FPE_FLTOVF_FAULT: abort ( "Floating overflow fault" );
#endif
#ifdef FPE_FLTDIV_FAULT
    case FPE_FLTDIV_FAULT: abort ( "Floating divide by zero fault" );
#endif
#ifdef FPE_FLTUND_FAULT
    case FPE_FLTUND_FAULT: abort ( "Floating underflow fault" );
#endif
    default              : abort ( "Floating exception" );
    }
}
