/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"


extern table_st *new_table ();


table_st *
append_tables ( tab1 , tab2 )
table_st *tab1 , *tab2;
{
    register table_st *p1 , *p2;
    table_st *newtab;
    int count;
    int i;


    if ( tab1 == NULL )
	return ( tab2 );
    if ( tab2 == NULL )
	return ( tab1 );
    p1 = tab1;
    p2 = tab2;
    count = 0;
    while ( p1 != NULL  &&  p2 != NULL ) {
	p1 = p1->next;
	p2 = p2->next;
	count++;
    }
    if ( p1 != NULL  ||  p2 != NULL )
	abort ( "Tables must be of same width to append them" );
    newtab = new_table ( count , tab1->size + tab2->size );
    for ( p1 = tab1, p2 = newtab; p1 != NULL; p1 = p1->next, p2 = p2->next )
	for ( i = 0; i < tab1->size; i++ )
	    p2->data[i] = p1->data[i];
    for ( p1 = tab2, p2 = newtab; p1 != NULL; p1 = p1->next, p2 = p2->next )
	for ( i = 0; i < tab2->size; i++ )
	    p2->data[i+tab1->size] = p1->data[i];
    free_table ( tab1 );
    free_table ( tab2 );
    return ( newtab );
}

