%{

/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


/* Declaration section */

#include <stdio.h>
#include "graph.h"
#include "y.tab.h"

extern int linenum;
extern char *	infilename;

extern char *	new ();

static struct {
    char *word;
    int token;
} reserved[] = {
    { "adjacent" , ADJACENT },
    { "append" , APPEND },
    { "as" , AS },
    { "assume" , ASSUME },
    { "at" , AT },
    { "auto" , AUTO },
    { "axis" , AXIS },
    { "bottom" , BOTTOM },
    { "by" , BY },
    { "center" , CENTER },
    { "centre" , CENTER },
    { "circle" , CIRCLE },
    { "cross" , CROSS },
    { "cumulate" , CUMULATE },
    { "date" , DATE },
    { "dotdashed" , DOTDASHED },
    { "dotted" , DOTTED },
    { "format" , FORMAT },
    { "frame" , FRAME },
    { "from" , FROM },
    { "generate" , GENERATE },
    { "graph" , GRAPH },
    { "grid" , GRID },
    { "group" , GROUP },
    { "include" , INCLUDE },
    { "interval" , INTERVAL },
    { "intervals" , INTERVAL },
    { "into" , INTO },
    { "join" , JOIN },
    { "label" , LABEL },
    { "left" , LEFT },
    { "legend" , LEGEND },
    { "line" , LINE },
    { "linear" , LINEAR },
    { "load" , LOAD },
    { "logarithmic" , LOGRITHMIC },
    { "logrithmic" , LOGRITHMIC },
    { "longdashed" , LONGDASHED },
    { "middle" , MIDDLE },
    { "no" , NO },
    { "outline" , OUTLINE },
    { "parameter" , PARAMETER },
    { "parms" , PARMS },
    { "performing" , PERFORMING },
    { "plot" , PLOT },
    { "plus" , PLUS },
    { "points" , POINTS },
    { "power" , POWER },
    { "print" , PRINT },
    { "put" , PUT },
    { "read" , READ },
    { "right" , RIGHT },
    { "save" , SAVE },
    { "scale" , SCALE },
    { "shell" , SHELL },
    { "shortdashed" , SHORTDASHED },
    { "size" , SIZE },
    { "solid" , SOLID },
    { "sort" , SORT },
    { "square" , SQUARE },
    { "str" , STR },
    { "tick" , TICK },
    { "to" , TO },
    { "top" , TOP },
    { "triangle" , TRIANGLE },
    { "val" , VAL },
    { "where" , WHERE },
    { "with" , WITH },
    { "xaxis" , XAXIS },
    { "yaxis" , YAXIS },
    { NULL , 0 }
};

%}

%% /* Rules section */

\<\=	{ return ( LE ); }
\>\=	{ return ( GE ); }
\<\>	{ return ( NE ); }
\!\=	{ return ( NE ); }
\=\=	{ return ( EQ ); }
\=	{ return ( EQ ); }
\>	{ return ( GT ); }
\<	{ return ( LT ); }
\"	{ read_string (); return ( STRING ); }
[a-zA-Z][a-zA-Z0-9_]*	{
	    int i;

	    for ( i = 0; reserved[i].word != NULL; i++ ) {
		if ( strcmp ( yytext , reserved[i].word ) == 0 )
		    return ( reserved[i].token );
	    }
	    yylval.string = new ( strlen ( yytext ) + 1 );
	    strcpy ( yylval.string , yytext );
	    if ( is_tab_ident ( yytext ) )
		return ( TAB_IDENT );
	    if ( is_var_ident ( yytext ) )
		return ( VAR_IDENT );
	    if ( is_ftab_ident ( yytext ) )
		return ( FTAB_IDENT );
	    if ( is_fvar_ident ( yytext ) )
		return ( FVAR_IDENT );
	    return ( IDENT );
	}
[0-9.]+|[0-9.]+e[+-]?[0-9]+	{
	    double num;

	    scan_value ( yytext , &num );
	    yylval.number = num;
	    return ( NUMBER );
	}
\&\&	{ return ( '&' ); /* synonym for & */ }
\|\|	{ return ( '|' ); /* synonym for | */ }
[ \t]	;
\#.*\n	{ linenum++; /* comment */ }
\n	{ linenum++; }
.	{ return ( yytext[0] ); }

%% /* Subroutine section */

yyerror ( str )
char *str;
{
    fprintf ( stderr , "%s: syntax error, line %d: %s\n" , infilename , linenum , str );
}


read_string ()
{
    char buf[200];
    char *p;
    int c;

    p = buf;
    while ( c = yyinput () ) {
	if ( c == '"' ) {
	    c = yyinput ();
	    if ( c == '"' )
		*p++ = '"';
	    else {
		yyunput ( c );
		break;
	    }
	}
	else
	    *p++ = c;
    }
    *p = '\0';
    yylval.string = new ( strlen ( buf ) + 1 );
    strcpy ( yylval.string , buf );
}

