/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include <math.h>
#include "graph.h"


extern double eval ();


#define MAX_DEC		50


static struct declare_st {
    char *name;
    double value;
} dec [ MAX_DEC ];

static int num_dec;



pdef_var ()
{
    var_declare ( "infinity" , HUGE );
}



var_declare ( name , value )
char *name;
double value;
{
    int i;

    for ( i = 0; i < num_dec; i++ ) {
	if ( strcmp ( name , dec[i].name ) == 0 ) {
	    dec[i].value = value;
	    return;
	}
    }
    if ( num_dec >= MAX_DEC )
	abort ( "Internal array overflow - too many variables declared" );
    dec[num_dec].name = name;
    dec[num_dec].value = value;
    num_dec++;
}




double
var_lookup ( name )
char *name;
{
    int i;

    for ( i = 0; i < num_dec; i++ ) {
	if ( strcmp ( dec[i].name , name ) == 0 ) {
	    return ( dec[i].value );
	}
    }
    abort ( "Undefined variable '%s' referenced" , name );
    return ( 0.0 );
}



is_var_ident ( name )
char *name;
{
    int i;

    for ( i = 0; i < num_dec; i++ ) {
	if ( strcmp ( dec[i].name , name ) == 0 ) {
	    return ( 1 );
	}
    }
    return ( 0 );
}


