/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"
#include "y.tab.h"

extern char *PROG_NAME;
extern axis_st xaxis;
extern axis_st yaxis;
extern graph_st graph[];
extern int num_graphs;
extern char *graph_label;
extern int horiz_legend;
extern int vert_legend;


reset_graphs ()
{
    int i;

    xaxis.format = yaxis.format = "%.1f";
    xaxis.user_format = yaxis.user_format = NULL;
    xaxis.label = yaxis.label = "";
    xaxis.scale = yaxis.scale = AUTO;
    xaxis.frame = yaxis.frame = GRID;
    xaxis.linear = yaxis.linear = LINEAR;
    xaxis.auto_tick_size = yaxis.auto_tick_size = 1;
    xaxis.range.min = yaxis.range.min = 0.0;
    xaxis.range.max = yaxis.range.max = -1.0;
    xaxis.interval = yaxis.interval = NULL;

    for ( i = 0; i < num_graphs; i++ ) {
	if ( graph[i].label != NULL )
	    release ( graph[i].label );
	if ( graph[i].legend != NULL )
	    release ( graph[i].legend );
	free_table ( graph[i].table );
    }

    if ( graph_label != NULL ) {
	release ( graph_label );
	graph_label = NULL;
    }

    num_graphs = 0;
    horiz_legend = RIGHT;
    vert_legend = TOP;
}

