/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#define MAX_GRAPHS 30

typedef struct table_st {
    int size;
    double *data;
    struct table_st *next;
} table_st;

typedef struct tnode_st {
    int operator;
    struct tnode_st *left , *right;
    struct table_st *table;
    struct expr_list_st *expr_list;
    struct attr_st *expr;
    char *ident;
    double value;
    struct range_st *range;
    struct int_st *interval;
    int func;
    struct parm_st *parm_list;
    struct trow_st *const_table;
} tnode_st;

typedef struct attr_st {
    double value;
    int node_type;
    struct attr_st *left , *right;
    char *ident;
    struct parm_st *parm_list;
} attr_st;

typedef struct expr_list_st {
    struct attr_st *expr;
    struct expr_list_st *next;
} expr_list_st;

typedef struct range_st {
    double min , max;
} range_st;

typedef struct int_st {
#define ISIZE	0
#define INUMINT	1
    int int_type;
    double value;
} int_st;

typedef struct graph_st {
    int line_type;	/* NO,DOTTED,SOLID,LONGDASHED,SHORTDASHED,DOTDASHED */
    int point_type;	/* A mask MSK_TRIANGLE etc */
#define MSK_CIRCLE	0x01
#define MSK_TRIANGLE	0x02
#define MSK_SQUARE	0x04
#define MSK_CROSS	0x08
#define MSK_PLUS	0x10
    int cumulative;	/* true/false */
    char *label;
    char *legend;	/* NULL means dont put in legend */
    table_st *table;
} graph_st;

typedef struct axis_st {
    char *format;	/* printf format for numbering axis */
    char *user_format;	/* user defined format */
    char *label;
    int scale;		/* AUTO,NO */
    int frame;		/* FRAME,GRID,OUTLINE,NO */
    int linear;		/* LOG,LINEAR */
    int auto_tick_size;	/* true/false */
    range_st range;
    int_st *interval;
    double tick_size;
    double power_10;
} axis_st;

typedef struct parm_st {
    int parm_type;
    char *ident;
    tnode_st *tab_expr;
    attr_st *expr;
    struct parm_st *next;
} parm_st;

typedef struct tcol_st {
    struct attr_st *expr;
    struct tcol_st *next;
} tcol_st;

typedef struct trow_st {
    struct tcol_st *cols;
    struct trow_st *next;
} trow_st;

