/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"



extern table_st *new_table ();



table_st *
generate ( range , interval )
range_st *range;
int_st *interval;
{
    table_st *table;
    int num_int;
    int i;
    double value;

    if ( interval == NULL )
	abort ( "GENERATE with no interval specified" );
    if ( range == NULL )
	abort ( "GENERATE with no range specified" );

    if ( interval->int_type == INUMINT )
	num_int = interval->value;
    else
	num_int = ( range->max - range->min ) / interval->value + 1;
    table = new_table ( 1 , num_int );

    if ( interval->int_type == INUMINT ) {
	value = range->min;
	for ( i = 0; i < num_int; i++ )
	    table->data[i] = range->min
		+ ( range->max - range->min ) * (double)i / interval->value;
    }
    else {
	value = range->min;
	for ( i = 0; i < num_int; i++ ) {
	    table->data[i] = value;
	    value += interval->value;
	}
    }
    return ( table );
}
