/*
 * Copyright (C) 1986   Alan Kent
 *
 * Permission is granted to freely distribute part or
 * all of this code as long as it is not for profit
 * and this message is retained in the code.
 *
 * No resposibility is taken for any damage or incorect
 * results this program generates.
 * 
 */


#include <stdio.h>
#include "graph.h"
#include "y.tab.h"


extern table_st *append_tables ();
extern table_st *adjacent ();
extern table_st *project ();
extern table_st *select ();
extern table_st *sort ();
extern table_st *join ();
extern table_st *tab_lookup ();
extern table_st *group ();
extern table_st *cumulate ();
extern table_st *generate ();
extern table_st *call_tab_fun ();
extern table_st *new_table ();
extern table_st *copy_of_table ();
extern double eval ();


table_st *
eval_tab ( expr )
tnode_st *expr;
{
    trow_st *trp;
    tcol_st *tcp;
    int num_rows , num_cols , tmp_cols;
    table_st *newtab , *tp;
    int row;


    switch ( expr->operator ) {

    case TABLE :
	num_rows = 0;
	num_cols = 0;
	for ( trp = expr->const_table; trp != NULL; trp = trp->next ) {
	    tmp_cols = 0;
	    for ( tcp = trp->cols; tcp != NULL; tcp = tcp->next ) {
		tmp_cols++;
	    }
	    if ( num_rows == 0 )
		num_cols = tmp_cols;
	    else
		if ( num_cols != tmp_cols )
		    abort ( "constant table has rows with different number of columns" );
	    num_rows++;
	}
	newtab = new_table ( num_cols , num_rows );
	row = 0;
	for ( trp = expr->const_table; trp != NULL; trp = trp->next ) {
	    for ( tcp = trp->cols, tp = newtab; tcp != NULL; tcp = tcp->next, tp = tp->next ) {
		tp->data[ row ] = eval ( NULL , 0 , tcp->expr );
	    }
	    row++;
	}
	return ( newtab );
	break;

    case TAB_CONST :
	return ( copy_of_table ( expr->table ) );
    
    case FTAB_IDENT :
	return ( call_tab_fun ( expr->ident , expr->parm_list , NULL , 0 ) );

    case APPEND :
	return ( append_tables ( eval_tab ( expr->left ) ,
	    eval_tab ( expr->right ) ) );
    
    case ADJACENT :
	return ( adjacent ( eval_tab ( expr->left ) ,
	    eval_tab ( expr->right ) ) );
    
    case PROJECT :
	return ( project ( eval_tab ( expr->left ) , expr->expr_list ) );

    case WHERE :
	return ( select ( eval_tab ( expr->left ) , expr->expr ) );

    case SORT :
	return ( sort ( eval_tab ( expr->left ) , (int)eval ( NULL , 0 , expr->expr ) ) );

    case JOIN :
	return ( join ( eval_tab ( expr->left ) , eval_tab ( expr->right ) ,
	    (int)eval ( NULL , 0 , expr->expr->left ) ,
	    (int)eval ( NULL , 0 , expr->expr->right ) ) );

    case CUMULATE :
	return ( cumulate ( eval_tab ( expr->left ) , (int)eval ( NULL , 0 , expr->expr ) ) );

    case GENERATE :
	return ( generate ( expr->range , expr->interval ) );

    case TAB_IDENT :
	return ( tab_lookup ( expr->ident ) );

    case GROUP :
	return ( group ( eval_tab ( expr->left ) , expr->range , expr->interval , expr->ident ) );

    default :
	abort ( "unknown operator in eval_tab: %d" , expr->operator );

    }
    return ( NULL );
}
