#ifndef lint
static char sccsid[] = "@(#) xdemo.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Cheap clone of an attention getting program I saw on a Xerox workstation.*/
/* system5 dtlewis 2 2.3.0-U AT */
/* Tue May 24 22:38:22 EDT 1988 */
/* by Dave Lewis */

#include <stdio.h>
#include "config.h"
#include "gl.h"
#if MS_DOS
#include <stdlib.h>
#define DOS_GET_TIME 0x2c
#define DOS_KBY_STAT 0x0b;
#define DOS 0x21
#endif /* MS_DOS */
#if MIX_C
#else
#include <signal.h>
#include <time.h>
#if MS_DOS
#include <dos.h>
#endif /* MS_DOS */
#endif /* MIX_C */

#define MAXINT 32767
#define NUMLINES 32

#define MSG_COUNT 11

#if MS_DOS
static REGISTERS inreg, outreg;
#endif /* MS_DOS */

void border()  {
	/* Draw a border and text message. */
	int color;
	color = g_pix_color(CYAN);
	n_box(0,0,32767,32767);
	n_movepen(2000,30000);
	g_fontctl(2.5, 1.0, 1.0, 0.0, 0.0);
	n_grafstr("XOR Write Mode");
	g_pix_color(1);
	n_line(16383,6000,16383,26767);
	n_line(6000,16383,26767,16383);
	g_pix_color(color);
}

void usage(progname)  
char *progname;
{
	fprintf (stderr,"Usage:  %s <mode>\n\n",progname);
	fprintf (stderr,"Where <mode> is:\n",0);
	fprintf (stderr,"\t4 (CGA 4 color 320 x 200)\n",0);
	fprintf (stderr,"\t6 (CGA 2 color 640 x 200)\n",0);
	fprintf (stderr,"\t8 (Hercules page 0, 720 x 348)\n",0);
	fprintf (stderr,"\t9 (Hercules page 1, 720 x 348)\n",0);
	fprintf (stderr,"\t16 (EGA color 640 x 350)\n",0);
	fprintf (stderr,"\t256 (IBM / Epson compatible printer)\n",0);
	fprintf (stderr,"\t257 (Laserjet+ printer)\n\n",0);
}

void pattern()  {

	long x1;
	long y1;
	long x2;
	long y2;
	int x1rate;
	int y1rate;
	int x2rate;
	int y2rate;
	int rand();
	int idx_to_buff;
	struct endpoints {
		int x1;
		int x2;
		int y1;
		int y2;
	} buff[NUMLINES]; 

	/* Initialize.	*/

	/* Modify the slopes and starting location of the endpoint	*/
	/* motion, to give different patterns every time we run the	*/
	/* program.							*/
	x1 = rand();
	y1 = rand();
	x2 = rand();
	y2 = rand();
	x1rate = rand() & 0x0FF + 256;
	y1rate = rand() & 0x0FF + 256;
	x2rate = rand() & 0x0FF + 256;
	y2rate = rand() & 0x0FF + 256;
	if (rand() & 0x01) x1rate *= -1;
	if (rand() & 0x01) y1rate *= -1;
	if (rand() & 0x01) x2rate *= -1;
	if (rand() & 0x01) y2rate *= -1;

	/* Initialize the line buffer to invalid values (so they don't	*/
	/* get plotted).						*/

	for (idx_to_buff=0; idx_to_buff < NUMLINES; idx_to_buff++)  {
		buff[idx_to_buff].x1 = -1;
		buff[idx_to_buff].y1 = -1;
		buff[idx_to_buff].x2 = -1;
		buff[idx_to_buff].y2 = -1;
	}

	idx_to_buff = 0;

	/* Start the display pattern.	*/

	/* Loop until <del> key is pressed. */
	for (;;)  {

#if MS_DOS
		/* Call to get keyboard status, so DOS can check for	*/
		/* interrupt signal (^C).				*/
		inreg.AH = DOS_KBY_STAT;
		DO_BIOS(DOS, &inreg, &outreg);
#endif /* MS_DOS */

		/* Increment buffer pointer, wrapping around buffer.	*/
		++idx_to_buff;
		idx_to_buff %= NUMLINES;

		/* Erase (redraw in XOR mode) old line. */
		n_line( buff[idx_to_buff].x1, 
			buff[idx_to_buff].y1, 
			buff[idx_to_buff].x2, 
			buff[idx_to_buff].y2
			);

		/* Get coordinates of new line. */
		if (((x1 += x1rate) < 0) || (x1 > MAXINT))  { 
			x1rate *= -1;
			x1 += (2 * x1rate);
			}
		if (((y1 += y1rate) < 0) || (y1 > MAXINT))  {
			y1rate *= -1;
			y1 += (2 * y1rate);
			}
		if (((x2 += x2rate) < 0) || (x2 > MAXINT))  {
			x2rate *= -1;
			x2 += (2 * x2rate);
			}
		if (((y2 += y2rate) < 0) || (y2 > MAXINT))  {
			y2rate *= -1;
			y2 += (2 * y2rate);
			}

		/* Store it in buffer. */
		buff[idx_to_buff].x1 = x1;
		buff[idx_to_buff].y1 = y1;
		buff[idx_to_buff].x2 = x2;
		buff[idx_to_buff].y2 = y2;

		/* Draw new line. */
		n_line( buff[idx_to_buff].x1, 
			buff[idx_to_buff].y1, 
			buff[idx_to_buff].x2, 
			buff[idx_to_buff].y2
			);
	}
}

void message()  {
	/* Write a cute message every time we get a time signal. */

#if MS_DOS
#else
	static int msg_count = 0;
#endif /* MS_DOS */
	int save_color;
	int save_pix_mode;
	save_color = g_pix_color(RED);
	save_pix_mode = g_pix_mode(XOR);
	c_cursor(2,2);
	c_cellstr("Press <Del> to quit...");
	g_pix_color(save_color);
	g_pix_mode(save_pix_mode);
#if MS_DOS
#else
	if (msg_count < MSG_COUNT)  {
		/* Do it MSG_COUNT times, then stop. */
		signal(SIGALRM,message);
		alarm(1);
		msg_count++;
	}
	else  {
		/* Erase the border by redrawing it.	*/
		border();
	}
#endif /* MS_DOS */
}

main(argc,argv)
int argc;
char *argv[];
{
	int mode;
	long timeval;
	long time();
	struct tm *timestruct;
	struct tm *gmtime();
	void srand();

	/* Get the mode to use. */

	if (argc < 2) mode = ENV_MODE;
	else if (argc == 2)  {
		if (sscanf(argv[1],"%d",&(mode)) != 1)  {
			usage(argv[0]);
			exit (1);
		}
	}
	else  {
		usage(argv[0]);
		exit (1);
	}

	/* Set video mode.	*/
	if (g_init(mode))  {
		usage(argv[0]);
		fprintf(stderr,"WARNING:  Possible invalid shared memory ",0);
		fprintf(stderr,"key for requested video mode.\n",0);
		exit (1);
	}

	/* Set for XOR mode. */
	g_pix_mode(XOR);

	/* Set pattern color.	*/
	g_pix_color(GREEN);

	/* Draw a border and a text message. */
	border();

#if MS_DOS
	message();
#else
	/* Fork and start flashing a cute message. */
	if (fork() == 0)  {
		/* Child process here. */
		/* Child should exit on receipt of a SIGINT signal	*/
		signal(SIGINT, SIG_DFL);
		/* Set a timer to post message. */
		signal(SIGALRM,message);
		alarm(3);
		for(;;) pause();
	}

	/* Parent process continues here. */
#endif /* MS_DOS */

	/* Get the current time, and use it as a seed value for the 	*/
	/* rand() function.						*/

#if MS_DOS
	/* Get the current time using DOS function 0x2c			*/
	inreg.AH = DOS_GET_TIME;
	DO_BIOS(DOS, &inreg, &outreg);
	srand((unsigned)outreg.DL);
#else
	timeval = time((long *) 0);
	timestruct = gmtime(&timeval);
	srand((unsigned)timestruct->tm_sec);
#endif /*MS_DOS */

	/* Draw the pattern.	*/

	pattern();
}
