#ifndef lint
static char sccsid[] = "@(#) n_draw.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988, 1989
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/*  Sat Mar 21 22:59:10 EST 1987 */
/*  dtl 2-8-87
**
**	Write a line on the CGA or Hercules adapter.
**	This routine assumes that the current graphics cursor position is
**	set, and draws a line to the indicated point.
*/

#include "config.h"
#include "bitmaps.h"
#include "graphics.h"
#include "gf_types.h"

#define ROT_MASK (0x80000000L)

extern struct GL_graphics graphics;
extern int (*p_do_pix)();

n_draw(new_x_cursor,new_y_cursor)  
	int new_x_cursor, new_y_cursor;
{

        /* Draw line from current cursor to new position. */
        /* Parameters are in normalized 2-D coordinates. */

        int x_dist;     /* Pixel coordinates */
        int y_dist;     /* Pixel coordinates */
        int x_start;    /* Pixel coordinates */
        int y_start;    /* Pixel coordinates */
        int x_final; 	/* Pixel coordinates */
        int y_final; 	/* Pixel coordinates */
        int x_current;  /* Pixel coordinates */
        int y_current;  /* Pixel coordinates */
	int x_pixels;	/* X distance in pixels */
	int y_pixels;	/* Y distance in pixels */
        long int slope;
        int offset;
        long int idx;

	/* Check for out of range.  If either the start or end	*/
	/* point would be off the screen, then we have a	*/
	/* problem.						*/

#if INT16
	/* 16 bit integers, use simple check.			*/
	if (graphics.x_cursor < 0 || graphics.y_cursor < 0 || 
		new_x_cursor < 0 || new_y_cursor < 0)
#else
	/* Use explicit check.					*/
	if (	(graphics.x_cursor < 0) 
		|| (graphics.x_cursor > NRM_X_RANGE) 
		|| (graphics.y_cursor < 0) 
		|| (graphics.y_cursor > NRM_Y_RANGE) 
		|| (new_x_cursor < 0)
		|| (new_x_cursor > NRM_X_RANGE)
		|| (new_y_cursor < 0)
		|| (new_y_cursor > NRM_Y_RANGE))
#endif /* INT16 */
	{
		/* Advance the cursor to the new position, even if	*/
		/* it is not a valid location.  In the case where the	*/
		/* current cursor is invalid but the new value is good,	*/
		/* this will correct the problem.  In the case where	*/
		/* the new value is bad, we will want to leave it that	*/
		/* way for the next invocation of n_draw().		*/
		graphics.x_cursor = new_x_cursor;
		graphics.y_cursor = new_y_cursor;
		return(1);
	}

        /* Find the starting point in pixel coordinates. */
  
        x_current = x_start = n_to_p_x(graphics.x_cursor);
        y_current = y_start = n_to_p_y(graphics.y_cursor);

        /* Find the end point in pixel coordinates. */
  
        x_final = n_to_p_x(new_x_cursor);
        y_final = n_to_p_y(new_y_cursor);

	/* Find the distances in pixel coordinates. */

        x_dist = x_final - x_start;
        y_dist = y_final - y_start;

	/* Find the number of pixels to travel in the x any y directions. */

	x_pixels = abs(x_dist);
	y_pixels = abs(y_dist);

        /* Step across the screen pixel by pixel.  Do this in the x 	*/
        /* direction if x_dist is greater than y_dist; else, do it in	*/
        /* the y direction.						*/

        if (x_pixels > y_pixels) {
                /* Stepwise in x direction. */

                /* Calculate the slope to use (rise over run). */
                /* Shift left 16 bits for precision. */
                if (x_dist != 0) slope = (long)y_dist * 0x010000L / 
                (long)x_dist;
                else slope = 0x7FFFFFFFL; /* Infinity */

                /* Figure a fudge factor to be used in offsetting the */
                /* pixels by 1/2 pixel. */
                if (slope > 0) offset = 1;
                else if (slope < 0) offset = -1;
                else offset = 0;

                /* Write the line on the screen. */

                if (x_final - x_start >= 0)  {
                        if (slope==0)  {
                                while (x_current <= x_final)
					if ((*p_do_pix)(x_current++, 
						y_current)) return(1);
                        }
                        else for (idx=0; idx <= x_pixels; idx++, x_current++)  {
                                y_current = y_start + (idx*slope/0x08000L 
                                + offset)/2;
                                if ((*p_do_pix)(x_current, y_current))
					return(1);
                        }
                }
                else  {
                        if (slope==0)  {
				while (x_current >= x_final)
                                        if ((*p_do_pix)(x_current--, 
						y_current)) return(1);
                        }
                        else for (idx=0; idx <= x_pixels; idx++, x_current--)  {
                                y_current = y_start - (idx*slope/0x08000L 
                                + offset)/2;
                                if ((*p_do_pix)(x_current, y_current)) 
					return(1);
                        }
                }
        }
        else  {
                /* Stepwise in y direction. */

                /* Calculate the inverse slope to use (run over rise). */
                /* Shift left 16 bits for precision. */
                if (y_dist != 0) slope = (long)x_dist * 0x010000L / 
                (long)y_dist;
                else slope = 0x7FFFFFFF; /* Infinity */

                /* Figure a fudge factor to be used in offsetting the */
                /* pixels by 1/2 pixel. */
                if (slope > 0) offset = 1;
                else if (slope < 0) offset = -1;
                else offset = 0;

               /* Write the line on the screen. */

                if (y_final - y_start >= 0)  {
                        if (slope==0)  {
                                while (y_current <= y_final)
                                        if ((*p_do_pix)(x_current, 
						y_current++)) return(1);
                        }
                        else for (idx=0; idx <= y_pixels; idx++, y_current++)  {
                                x_current = x_start + (idx*slope/0x08000L 
                                + offset)/2;
                                if ((*p_do_pix)(x_current, y_current))
					return(1);
                        }
                }
                else  {
                        if (slope==0)  {
				while (y_current >= y_final)
                                        if ((*p_do_pix)(x_current, 
						y_current--)) return(1);
                        }
                        else for (idx=0; idx <= y_pixels; idx++, y_current--)  {
                                x_current = x_start - (idx*slope/0x08000L 
                                + offset)/2;
                                if ((*p_do_pix)(x_current, y_current))
					return(1);
                        }
                }
        }
        /* Advance the cursor to the new position. */
        graphics.x_cursor = new_x_cursor;
        graphics.y_cursor = new_y_cursor;
	return(0);
}
