#ifndef lint
static char sccsid[] = "@(#) g_finish.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */


/* Wed Feb 10 20:58:37 EST 1988						*/
/* Detach shared memory and do any other clean up chores.		*/
/* If printing, the print job is dispatched to the print spooler.	*/
/* This routine is specific to Microport System V/AT, and presumes 	*/
/* that shared memory segments have been defined (usually at system 	*/
/* boot time) such that	the shared memory keys are "B8000L" for CGA 	*/
/* adapter, and so on. */

#define MODULE "g_finish"

#include "config.h"
#include <stdio.h>
#if MIX_C
#else
#include <sys/types.h>
#include <string.h>
#if TCC
#else
#include <malloc.h>
#endif /* TCC */
#endif /* MIX_C */
#if MS_DOS
extern int g_setmod();
extern int g_text;
#else
#include <sys/ipc.h>
#endif /* MS_DOS */
#if HAS_SIG
#include <signal.h>
#endif /* HAS_SIG */
#include "bitmaps.h"
#include "graphics.h"
#include "modes.h"

extern struct GL_graphics graphics;
extern int errno;
extern int g_clear();
extern char *getenv();
#if HAS_SIG
extern SIG_TYPE (*gl_last_int_handler)();
#endif /* HAS_SIG */

static FILE *fhandle;

extern int IBM_send_print();
extern int LJ_send_print();

static int open_print()
{
	char printprog[60];
	char *envptr;
	int istat;
	/* Open a pipe to the print spooler (or straight to printer)	*/

	/* Use the environment variable PLOTDEV if set. */

	strcpy(printprog, PRINTPROG);
	strcat(printprog, " ");
	strcat(printprog, LP_DEV_FLAG);
#if HAS_ENV
	if ((envptr = getenv(GL_PLOT_DEV)) != NULL)  {
		strcat(printprog, envptr);
	}
	else  {
		strcat(printprog, PRINTDEV);
	}
#else
	/* Some systems do not understand getenv()	*/
	strcat(printprog, PRINTDEV);
#endif /* HAS_ENV */

#if HAS_PIPES	/* Pipe to a print spooler program.			*/
	if ((fhandle = popen(printprog, "w")) == NULL)  {
		fprintf(stderr, "%s:  Error piping to %s\n", MODULE,printprog);
		return(1); 
	}
#else		/* No pipes; write directly to the printer device.	*/
#if HAS_STDPRN	/* Use predefined value of "stdprn"			*/
	fhandle = stdprn;	
#else		/* Hope that stream I/O works for the printer device	*/
	if ((fhandle = fopen(DOSPRINTER, "w")) == NULL)  {
		fprintf(stderr, "%s:  Error opening %s\n", MODULE,DOSPRINTER);
		return(1); 
	}
#endif /* HAS_STDPRN */
#endif /* HAS_PIPES */
	return(0);
}

static int close_print()
{
	int istat;
#if HAS_PIPES
	if ((istat=pclose(fhandle)) < 0) return(istat);
#else	/* No pipe to close, but close the stream to printer if open	*/
#if HAS_STDPRN	/* Don't need to do anything -- stdprn stays open	*/
#else		/* Close the stream pointing at the printer		*/
	if ((istat=fclose(fhandle)) < 0) return(istat);
#endif /* HAS_STDPRN */
#endif /* HAS_PIPES */
	return(0);
}

int g_finish()
{
	int istat;

	graphics.initialized = FALSE;

#if HAS_SIG
#if DO_CLEANUP
	/* Restore the SIGINT signal handler that was in effect prior	*/
	/* to the call to g_init().					*/
	signal(SIGINT, gl_last_int_handler);
#endif /* DO_CLEANUP */
#endif /* HAS_SIG */

	switch (graphics.grafmode)  {

		case CGA_HI_RES_MODE:
			/* Erase graphics memory.		*/
			if (g_clear()) return(1);
			/* Detach the shared memory segment.	*/
#if SVAT
			if (shmdt(graphics.cgamem) < 0) return(errno);
#endif /* SVAT */
			break;

		case CGA_COLOR_MODE:
			/* Erase graphics memory.		*/
			if (g_clear()) return(1);
			/* Detach the shared memory segment.	*/
#if SVAT
			if (shmdt(graphics.cgamem) < 0) return(errno);
#endif /* SVAT */
			break;

		case EGA_COLOR_MODE:
			/* Erase graphics memory.		*/
			if (g_clear()) return(1);
			/* Detach the shared memory segment.	*/
#if SVAT
			if (shmdt(graphics.egamem) < 0) return(errno);
#endif /* SVAT */
			break;

		case HERC_P0_MODE:
		case HERC_P1_MODE:
			/* Erase graphics memory.		*/
			if (g_clear()) return(1);
			/* Detach the shared memory segment.	*/
#if SVAT
			if (shmdt(graphics.hercmem) < 0) return(errno);
#endif /* SVAT */
			break;

		case IBM_PRINTER:

			/* Print the buffer */
			if ((istat=open_print()) !=0) return(istat);
			if ((istat=IBM_send_print(fhandle)) !=0) return(istat);
			if ((istat=close_print()) !=0) return(istat);

			/* Free the allocated memory. */
			free(graphics.printbuf1);
			free(graphics.printbuf2);
			free(graphics.printbuf3);

			break;

		case LJ_PRINTER:

			/* Print the buffer */
			if ((istat=open_print()) !=0) return(istat);
			if ((istat=LJ_send_print(fhandle)) !=0) return(istat);
			if ((istat=close_print()) !=0) return(istat);

			/* Free the allocated memory. */
			free(graphics.lj_buf1);
			free(graphics.lj_buf2);
			free(graphics.lj_buf3);

			break;

		default:
			return(1);
	}

	/* Tell the hardware to go back to default (text) mode, using	*/
	/* the MODEPROG program.  The default action of the mode	*/
	/* program is assumed to be text mode.				*/

	if (graphics.grafmode <= MAXVIDEO)  {
#if MS_DOS
		g_setmod(g_text);
#else
		system(MODEPROG);
#endif /* MS_DOS */
	}

	return(0);
}


