#ifndef lint
static char sccsid[] = "@(#) g_clear.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/*
 *	Routine to clear video memory (or print buffer memory).  
 *	dtlewis 6-28-87
 *	Sun Mar 13 21:13:59 EST 1988
 */

#include "config.h"
#include "bitmaps.h"
#include "graphics.h"
#include "modes.h"

extern int g_init(), g_finish();

int g_clear()  
{
	extern struct GL_graphics graphics;
	int i, j;
	int istat;

#if MIX_C
	/* No long pointers with this compiler.  Cheat and use BIOS.	*/
	g_setmod(graphics.grafmode);
	return(0);
#endif /* MIX_C */

	switch (graphics.grafmode) {
		case CGA_COLOR_MODE:
			for(i=0; i<100; i++)  {
				for(j=0; j<80; j++)  {
					(graphics.cgamem)->page1[i][j] = 0x0;
					(graphics.cgamem)->page2[i][j] = 0x0;
				}
			}
			break;

		case CGA_HI_RES_MODE:
			for(i=0; i<100; i++)  {
				for(j=0; j<80; j++)  {
					(graphics.cgamem)->page1[i][j] = 0x0;
					(graphics.cgamem)->page2[i][j] = 0x0;
				}
			}
			break;

		case EGA_COLOR_MODE:
			for (i=0 ; i<350 ; i++) {
				for (j=0 ; j<80 ; j++) {
					(graphics.egamem)->mem[i][j] = 0x0;
				}
			}
			break;

		case HERC_P0_MODE:
		case HERC_P1_MODE:
			for(i=0; i<87; i++)  {
				for(j=0; j<90; j++)  {
					(graphics.hercmem)->page1[i][j] = 0x0;
					(graphics.hercmem)->page2[i][j] = 0x0;
					(graphics.hercmem)->page3[i][j] = 0x0;
					(graphics.hercmem)->page4[i][j] = 0x0;
				}
			}
			break;

		/* For hard copy, there is no point in clearing	*/
		/* memory.  We will interpret this call as	*/
		/* "done with this page; send it to the printer	*/
		/* and get ready for another."			*/

		case IBM_PRINTER:
			if ((istat=g_finish()) != 0) return(istat);
			if ((istat=g_init(IBM_PRINTER)) != 0) return(istat);
			break;

		case LJ_PRINTER:
			if ((istat=g_finish()) != 0) return(istat);
			if ((istat=g_init(LJ_PRINTER)) != 0) return(istat);
			break;

		default:
			return(1);

	}
	return(0);
}
