#ifndef lint
static char sccsid[] = "@(#) c_cellch.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Write a graphics character to the screen.				*/
/* This routine uses bit mapped character cell fonts.			*/
/* The character will be drawn such that the current graphics cursor	*/
/* denotes the upper left corner of the character cell.  The graphics	*/
/* cursor will be incremented in the X direction by an amount corres-	*/
/* ponding to one character cell.  The location of the graphics cursor	*/
/* may be set by calls to either c_cursor() or p_movepen() prior	*/
/* calling this routine.	 					*/

/* Tue Mar 15 22:46:31 EST 1988						*/
/* system5 dtlewis 2 2.3.0-U AT						*/

#include "config.h"
#include "bitmaps.h"
#include "graphics.h"
#include "cellfont.h"

extern struct GL_graphics graphics;
extern int p_wr_pix(), n_movepen();

int c_cellchar(asc_char)  
unsigned char asc_char;
{
	int x, y, i, j;
	int istat = 0;

	char *bits; 

	/* Get the pixel location.					*/
	x = n_to_p_x(graphics.x_cursor);
	y = n_to_p_y(graphics.y_cursor);

	/* Check for x or y off the screen.			*/
#if INT16
	/* 16 bit integers, use simple check.			*/
        if (x < 0 ) return(1);
        if (y < 0 ) return(1);
#else
	/* Use explicit check.					*/
        if ((x < 0) || (x > NRM_X_RANGE)) return(1);
        if ((y < 0) || (y > NRM_X_RANGE)) return(1);
#endif /* INT16 */

	/* Increment the graphics cursor.				*/

	if (n_movepen(graphics.x_cursor + graphics.cellfont.xtic,
		graphics.y_cursor)) istat = 1;

	/* Point at the character bit map to print.			*/
	bits = (char *) &(charcell[asc_char * Y_CELL_BITS]);

	/* Write the character.						*/
	for (i=y; i < y + Y_CELL_BITS; i++, bits++) {
		j=x;
		if (*bits & 0x80) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x40) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x20) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x10) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x08) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x04) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x02) if (p_wr_pix(j,i)) istat = 1; j++;
		if (*bits & 0x01) if (p_wr_pix(j,i)) istat = 1; j++;
	}

	return(istat);
}
