#ifndef lint
static char sccsid[] = "@(#) testpat.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

#include "config.h"
#include <stdio.h>
#if MIX_C
#else
#include <math.h>
#endif /* MIX_C */
#if XEN2DOS
#include <dos.h>
#endif /* XEN2DOS */
#if USOFT
#include <dos.h>
#endif /* USOFT */
#include "gl.h"

#ifndef M_PI_2
#define M_PI_2	1.5707963268 
#endif /* M_PI_2 */
#ifndef M_PI_4
#define M_PI_4	0.7853981634 
#endif /* M_PI_4 */

static char str[20];

/* Routines to put test patterns on the screen.	*/

int lines()  {

	if (n_line(4000,4000,20000,20000)) return(1);

        if (n_movepen(6000,6000)) return(1);
        if (n_draw(12000,6000)) return(1);
        if (n_draw(12000,12000)) return(1);
        if (n_draw(6000,12000)) return(1);
        if (n_draw(6000,6000)) return(1);

        if (n_movepen(6000,6000)) return(1);
        if (n_draw(12000,12000)) return(1);

	g_pix_color(CYAN);

	if (n_box(700,700,900,1200)) return(1);
	if (n_box(900,1200,1100,1700)) return(1);
	if (n_box(20000,20000,30000,30000)) return(1);

	if (n_box(1000,10000,12000,12000)) return(1);
	if (n_box(9000,9000,13000,13000)) return(1);
	if (n_box(8000,8000,14000,14000)) return(1);
	if (n_box(7000,7000,15000,15000)) return(1);
	if (n_box(6000,6000,16000,16000)) return(1);

        if (n_movepen(2000,13000)) return(1);
        if (n_draw(4000,13000)) return(1);
        if (n_movepen(4000,13300)) return(1);
        if (n_draw(2000,13300)) return(1);

	g_pix_color(GREEN);

        if (n_movepen(2000,14000)) return(1);
        if (n_draw(30000,14400)) return(1);
        if (n_draw(2000,14800)) return(1);
        if (n_draw(30000,15200)) return(1);
        if (n_draw(2000,15600)) return(1);
        if (n_draw(30000,16000)) return(1);
        if (n_draw(2000,16400)) return(1);
        if (n_draw(30000,16800)) return(1);
        if (n_draw(2000,17200)) return(1);
        if (n_draw(30000,17600)) return(1);
        if (n_draw(2000,18000)) return(1);
        if (n_draw(30000,18400)) return(1);
        if (n_draw(0,18800)) return(1);
        if (n_draw(32000,19200)) return(1);
        if (n_draw(0,19600)) return(1);
        if (n_draw(32000,20000)) return(1);
        if (n_draw(0,20400)) return(1);
        if (n_draw(32000,20800)) return(1);
        if (n_draw(0,21200)) return(1);
        if (n_draw(32000,21600)) return(1);
        if (n_draw(0,22000)) return(1);
        if (n_draw(32000,22400)) return(1);

        if (n_movepen(6000,4000)) return(1);
        if (n_draw(6200,30000)) return(1);
        if (n_draw(6400,4000)) return(1);
        if (n_draw(6600,30000)) return(1);
        if (n_draw(6800,4000)) return(1);
        if (n_draw(7000,30000)) return(1);
        if (n_draw(7200,4000)) return(1);
        if (n_draw(7400,30000)) return(1);
        if (n_draw(7600,4000)) return(1);
        if (n_draw(7800,30000)) return(1);
        if (n_draw(8000,4000)) return(1);
        if (n_draw(8200,30000)) return(1);
        if (n_draw(8400,4000)) return(1);

	g_pix_color(BLUE);

        if (n_movepen(2000,2000)) return(1);
        if (n_draw(32000,4000)) return(1);
        if (n_draw(31000,32000)) return(1);
        if (n_draw(1000,30000)) return(1);
        if (n_draw(2000,2000)) return(1);
        if (n_draw(31000,32000)) return(1);

        if (n_movepen(0,0)) return(1);
        if (n_draw(32767,0)) return(1);
        if (n_draw(32767,32767)) return(1);
        if (n_draw(0,32767)) return(1);
        if (n_draw(0,0)) return(1);
        if (n_draw(32767,32767)) return(1);
        if (n_movepen(0,32767)) return(1);
        if (n_draw(32767,0)) return(1);

	return(0);
}

int linestyles()  {
	n_box(1000,1000,30000,30000);
	g_style(DOTTED);
	n_box(2000,2000,29000,29000);
	g_style(DOTDASHED);
	n_box(3000,3000,28000,28000);
	g_style(DASHED);
	n_box(4000,4000,27000,27000);
	g_style(SHORTDASHED);
	n_box(5000,5000,26000,26000);
	g_style(LONGDASHED);
	n_box(6000,6000,25000,25000);
	g_style(SOLID);
	n_box(7000,7000,24000,24000);
	g_style(DASHED);
	n_movepen(15500,7000);
	n_draw(24000,15500);
	n_draw(15500,24000);
	n_draw(7000,15500);
	n_draw(15500,7000);
	g_style(SOLID);
	n_movepen(12000,15000);
	c_cellstr("Line Styles");

	return(0);
}

curvestyles()  {
	n_ellipse(15500,15500,15000,15000);
	g_style(DOTTED);
	n_ellipse(15500,15500,14000,13000);
	g_style(DOTDASHED);
	n_ellipse(15500,15500,13000,11000);
	g_style(DASHED);
	n_ellipse(15500,15500,12000,9000);
	g_style(SHORTDASHED);
	n_ellipse(15500,15500,11000,7000);
	g_style(LONGDASHED);
	n_ellipse(15500,15500,10000,5000);
	g_style(SOLID);
	n_ellipse(15500,15500,9000,3000);
	n_movepen(12000,15000);
	c_cellstr("Ellipses");

	return(0);
}

int strings()  {

	n_movepen(10,5000);
	if (n_grafstr("AbCdEfGhIjKlMnOpQrStUvWxYz")) 
		return(1);

	/* Don't worry about errors from here on out.  We will get	*/
	/* an error return code each time we try to write off the edge	*/
	/* of the screen.						*/

	g_pix_color(MAGENTA);

	g_fontctl(2.0, 1.0, 1.0, 0.0, 0.0);
	n_movepen(100, 10000);
	n_grafstr("AbCdEfGhIjKlMnOpQrStUvWxYz");
	g_fontctl(4.0, 1.0, 1.0, 0.0, 0.0);
	n_movepen(100, 15000);
	n_grafstr("AbCdEfGhIjKlMnO");
	g_fontctl(3.0, 1.0, 1.0, 0.0, 0.0);
	n_movepen(100, 20000);
	n_grafstr("Z#$%^&*()+");
	g_fontctl(3.0, 2.0, 1.0, 0.0, 0.0);
	n_movepen(100, 24000);
	n_grafstr("Z#$%^&*()+");
	g_fontctl(3.0, 2.0, 2.0, 0.0, 0.0);
	n_movepen(100, 28000);
	n_grafstr("Z#$%^&*()+");

	return (0);

}

int chars()  {

	int idx;
	char string1[65];
	char string2[65];
	char string3[65];
	char string4[65];

	g_pix_color(RED);

	if (c_cursor(1,1)) return(1);
	if (c_cellstr("* <== This is (1,1)")) return(1);

	/* Don't worry about errors from here on out.  We will get	*/
	/* an error return code each time we try to write off the edge	*/
	/* of the screen.						*/

	c_cursor(2,30);
	c_cellstr("* <== This is (2,30)");

	c_cursor(3,60);
	c_cellstr("* <== This is (3,60)");

	c_cursor(10,40);
	c_cellstr("* <== This is (10,40)");

	c_cursor(25,40);
	c_cellstr("X");

	c_cursor(25,80);
	c_cellstr("X");

	c_cursor(43,90);
	c_cellstr("X");

	c_cursor(2,1); 
	c_cellstr("This");
	c_cursor(3,1); 
	c_cellstr(" Is ");
	c_cursor(4,1); 
	c_cellstr("  A ");
	c_cursor(5,1); 
	c_cellstr("TEST");
	c_cursor(6,1); 
	c_cellstr("XXXX");
	c_cursor(7,1); 
	c_cellstr("XXXX");

	for (idx=0;idx<64;idx++)  {
		string1[idx]=idx;
		string2[idx]=idx+64;
		string3[idx]=idx+128;
		string4[idx]=idx+192;
	}
	string1[64]=0;
	string2[64]=0;
	string3[64]=0;
	string4[64]=0;

	/* The first character of string1[] is a null, making it a	*/
	/* null string.  No good.  Make it the same as the second.	*/

	string1[0] = string1[1];

	c_cursor(11,1);
	c_cellstr(string1);
	c_cursor(12,2);
	c_cellstr(string2);
	c_cursor(13,3);
	c_cellstr(string3);
	c_cursor(14,4);
	c_cellstr(string4);
	c_cursor(15,5);
	c_cellstr(string1);
	c_cursor(16,6);
	c_cellstr(string2);
	c_cursor(17,7);
	c_cellstr(string3);
	c_cursor(18,8);
	c_cellstr(string4);

	for (idx=1;idx<=10;idx++)  {
		if (! c_cursor(idx,20)) c_cellstr("XHIHX");
	}

	return (0);
}

int charset()  {
	int x,y;

	char cval = 0;
	g_pix_color(CYAN);
	for (y=1; y<=60; y++)  {
		for (x=1; x<=140; x++)  {
			if (! c_cursor(y,x))  {
				c_cellchar(cval);
				cval = (++cval) & 0xff;
			}
		}
	}
}

int strokeset()  {
	int x,y;

	char cval = 0;
	g_pix_color(CYAN);
	g_fontctl(2.0, 1.0, 1.0, 0.0, 0.0);
	for (y=1; y<=60; y += 2)  {
		for (x=1; x<=140; x += 2)  {
			if (! c_cursor(y,x))  {
				n_grafchar(cval);
				cval = (++cval) & 0x7f;
			}
		}
	}
}

int slanttext()  {

	g_pix_color(LT_CYAN);
	n_movepen(6000,100);
	g_fontctl(4.0, 1.0, 1.0, 0.0, 0.0);
	n_grafstr("Text");

	n_movepen(6000,4100);
	n_grafstr("Can be");

	g_pix_color(LT_GREEN);
	n_movepen(6000,8100);
	g_fontctl(4.0, 1.0, 1.0, 0.0, 0.2);
	n_grafstr("Slanted!");

	g_pix_color(YELLOW);
	n_movepen(10,30000);
	g_fontctl(4.0, 1.0, 1.0, M_PI_2, 0.0);
	n_grafstr("Rotated!");

	g_pix_color(LT_RED);
	n_movepen(6000,28000);
	g_fontctl(4.0, 1.0, 1.0, M_PI_4, 0.0);
	n_grafstr("Or ");
	g_fontctl(4.0, 1.0, 1.0, M_PI_4, 0.2);
	n_grafstr("Both!");
}

int fillscreen()  {
	int x,y;
	char cval;
	g_pix_color(CYAN);
	for (x=1; x<=140; x++)  {
		for (y=1; y<=60; y++)  {
			cval = ((x+y-1)%10+'0');
			if (! c_cursor(y,x)) c_cellchar(cval);
		}
	}
	n_box(0,0,32767,32767);
}

ellipses()  {
	int idx;

	g_pix_color(CYAN);
	n_ellipse(10000,10000,4000,6000);
	n_ellipse(24000,15000,5000,6000);
	n_ellipse(20000,10000,6000,4000);
	n_ellipse(18000,18000,4000,3000);
	n_ellipse(10000,20000,7000,6000);
	n_ellipse(15000,24000,8000,8000);
	n_ellipse(10000,28000,5000,6000);

	for (idx=10; idx< 20000; idx +=400)  {
		n_ellipse(1000+idx,1000+idx,idx,idx);
	}
}

arcs()  {
	int idx;

	g_pix_color(RED);
	for (idx=10; idx< 20000; idx +=200)  {
		n_arc(15000,15000,1000+idx,1000+idx,(float)idx,(float)idx+0.4);
	}
}

plotpattern(size)
int size;
{
	/* Use the plot(3) interface to draw a bunch of junk, scaled 	*/
	/* according to the value of size.				*/

	space(0,0,size,size);
	move(1000,1000);
	label("This is the BSD plot(3) interface.");
	circle(1000,1000,100);
	circle(1000,1000,200);
	circle(1000,1000,400);
	circle(1000,1000,800);
	cont(2000,2000);
	move(0,0);
	cont(0,3120);
	cont(3120,3120);
	cont(3120,0);
	cont(0,0);
}

plotcircles()  {
	erase();

	space(0,0,1000,1000);

	move(0,0);
	cont(999,0);
	cont(999,999);
	cont(0,999);
	cont(0,0);

	circle(500,500,100);
	circle(500,500,200);
	circle(500,500,300);
	circle(500,500,400);
	circle(500,500,500);
	circle(500,500,600);
	circle(500,500,700);
	circle(500,500,800);
}

plotarcs()  {
	erase();

	arc(500,500,600,500,400,400);
	arc(500,500,700,500,400,400);
	arc(500,500,800,500,400,400);
	arc(500,500,900,500,400,400);
	arc(500,500,1000,500,400,400);
	arc(500,500,1100,500,400,400);
	arc(500,500,1200,500,400,400);
	arc(500,500,1300,500,400,400);
}

int plotstyles()  {
	space(0,0,1000,1000);
	erase();
	move(0,0);
	cont(1000,0);
	cont(1000,1000);
	cont(0,1000);
	cont(0,0);
	linemod("dotdashed");
	line(100,0,900,100);
	linemod("solid");
	line(100,100,900,100);
	line(100,100,900,200);
	linemod("dotted");
	line(100,200,900,200);
	line(100,200,900,300);
	linemod("shortdashed");
	line(100,300,900,300);
	line(100,300,900,400);
	linemod("longdashed");
	line(100,400,900,400);
	line(100,400,900,500);
	linemod("dotdashed");
	line(100,500,900,500);
	line(100,500,900,600);
	linemod("take the default (solid)");
	line(100,600,900,600);
	line(100,600,900,700);
	linemod("dotted");
	line(100,700,900,700);
	line(100,700,900,800);
	linemod("shortdashed");
	line(100,800,900,800);
	line(100,800,900,900);
	linemod("longdashed");
	line(100,900,900,900);
	line(100,900,900,1000);
}

testplot()
{
	/* Exercise the plot(3) interface.				*/
	openpl();
	plotpattern(3120);
	plotpattern(6240);
	plotpattern(12480);
	gets(str);
	plotcircles();
	gets(str);
	plotarcs();
	gets(str);
	plotstyles();
	gets(str);
	closepl();
	exit(0);
}

int cursor(x,y)
int x, y;
{
	n_line(x-800,y,x+800,y);
	n_line(x,y-1000,x,y+1000);
	return(0);
}

int showcursor()  {

#define MAX_BOUND_ 28000
#define MIN_BOUND 4000

	int idx,i,j,xinc,yinc;

	if (n_box(0,0,32767,32767)) return(1);
	if (n_box(1000,1200,31767,31567)) return(1);
	if (n_box(2000,2400,30767,30367)) return(1);

	g_pix_mode(XOR);

	xinc = 380;
	yinc = 330;
	i = 14300;
	j = 17324;

	cursor (i,j);

	for (idx=0; idx<1600; idx++)  {
		cursor (i,j);
		if (i < MIN_BOUND || i > MAX_BOUND_) xinc = - xinc;
		if (j > MAX_BOUND_) yinc = - yinc - 10;
		if (j < MIN_BOUND) yinc = - yinc; 
		i += xinc;
		j += yinc;
		cursor (i,j);
	}

	g_pix_mode(OR);

	return(0);
}
