#ifndef lint
static char sccsid[] = "@(#) plot.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

#include "config.h"
#include "gf_types.h"
#include <stdio.h>
#if MIX_C
#else
#include <math.h>
#endif /* MIX_C */
#include "modes.h"
#include "bitmaps.h"
#include "graphics.h"

/* The following declarations copied from gl.h.	*/
extern int g_clear();
extern int g_init();
extern int g_finish();
extern long g_style();
extern int c_cellstr();
extern int n_movepen();
extern int n_line();
extern int n_draw();
extern int n_arc();
extern int n_ellipse();
extern int n_point();

extern struct GL_graphics graphics;

/* These routines emulate the BSD plot(3) library.
 *
 * The arc() routine may vary slightly from the BSD version,
 * in that it calculates start and end angles with trig
 * functions, rather than with simple integer approximations
 * used in the BSD routine.
 *
 * plot:	openpl,	erase, label, line, circle, arc, move, cont,
 * point, linemod, space, closepl - graphics interface
 *
 * Coordinate transformations, using X0, X1, Y0, Y1 set in space(): 
 * X:
 * 	x' = x * (NRM_X_RANGE)/(X1-X0) - (X0*NRM_X_RANGE)/(X1-X0)
 * 	x' = (X0*NRM_X_RANGE + x*NRM_X_RANGE) / (X1-X0)
 * 
 * 	xconst = X0*NRM_X_RANGE;
 * 	xdiv = X1-X0;
 * 	x' = (xconst+x*NRM_X_RANGE)/xdiv;
 * 
 * Y:
 * 	y' = y * (-NRM_Y_RANGE)/(Y1-Y0) + (Y1*NRM_Y_RANGE)/(Y1-Y0)
 * 	y' = (Y1*NRM_Y_RANGE - y*NRM_Y_RANGE) / (Y1-Y0)
 * 
 * 	yconst = Y1*NRM_Y_RANGE;
 * 	ydiv = Y1-Y0;
 * 	y' = (yconst-y*NRM_Y_RANGE)/ydiv;
 */

/* X_TO_NORM(x) and Y_TO_NORM(y) are used to translate from the plot()	*/
/* coordinate system, as defined by scale(), to the normalized 2-D	*/
/* coordinate system of the screen.					*/

#define X_TO_NORM(x) ((int)((xconst+x*NRM_X_RANGE)/xdiv))
#define Y_TO_NORM(y) ((int)((yconst-y*NRM_Y_RANGE)/ydiv))

/* X_SCALE_NORM() and Y_SCALE_NORM() are used for scaling magnitudes.	*/

#define X_SCALE_NORM(x) (((x)*(NRM_X_RANGE))/(xdiv))
#define Y_SCALE_NORM(y) (((y)*(NRM_Y_RANGE))/(ydiv))

static long xconst,xdiv,yconst,ydiv;	/* Used in space() transforms.	*/

int openpl()
{
	/* Try to get the mode from the environment.		*/
	/* If no environment variable, use a default.		*/
	if((g_init(ENV_MODE)) == 0) return(0);
	else {
		/* Put warning message to standard error, then	*/
		/* continue.					*/
		fprintf(stderr,"Use environment variable %s to control mode.\n",
			GL_ENV_MODE);
		fprintf(stderr,"Continuing with default mode %d\n",
			DEFAULT_MODE);
		sleep(2);
		return(g_init(DEFAULT_MODE));
	}
}

int erase()
{
	return(g_clear());
}

int label(s)
char s[];
{
	return(c_cellstr(s));
}

int line(x_1, y_1, x_2, y_2)
int x_1,y_1,x_2,y_2;
{
	return(n_line(
		X_TO_NORM(x_1),Y_TO_NORM(y_1),X_TO_NORM(x_2),Y_TO_NORM(y_2)));
}

int circle(x, y, r)
{
	int x_axis=X_SCALE_NORM(r);
	int y_axis=Y_SCALE_NORM(r);
	return(n_ellipse(X_TO_NORM(x), Y_TO_NORM(y), x_axis, y_axis));
}

int arc(x, y, x_0, y_0, x_1, y_1)
{
	int x_axis, y_axis;		/* Major and minor axes.	*/
	float angle1, angle2;		/* Start and end angles.	*/
	int radius;	/* Radius, as calculated from sqrt(x**2+y**2).	*/
	long dx_0 = x_0 - x;
	long dy_0 = y_0 - y;
	long dx_1 = x_1 - x;
	long dy_1 = y_1 - y;

	/* We will draw a section of elliptical arc with major and 	*/
	/* minor axes such that it appears as a circle on the screen.	*/
	/* We know the center of the arc (x and y), and the ratio of	*/
	/* the major and minor axes (b/a equals graphics.aspect_ratio).	*/
	/* Given the start and end points of the arc, we need to solve	*/
	/* for the first and second angle, and then for major and minor	*/
	/* axes.							*/
	/* These values can be used to call the n_arc() routine.	*/

	/* WARNING:  The value of angle2 is calculated directly as the	*/
	/* angle of the vector from (x,y) to (x_1,y_1).  The original	*/
	/* versions of plot(3) from the BSD code apparently use		*/
	/* a simplistic approximation to this, which may lead to	*/
	/* different screen displays for arcs drawn with the BSD	*/
	/* code.  The basic idea for the user, however, should be to	*/
	/* specify x_1 and y_1 such that they fall very close to the	*/
	/* intended angle.						*/

	angle1 = (float)(-atan2((double)dy_0,(double)dx_0));
	angle2 = (float)(-atan2((double)dy_1,(double)dx_1));

	radius = ((int)(sqrt(fabs((double)(dx_0*dx_0+dy_0*dy_0)))));
	x_axis = X_SCALE_NORM(radius);
	y_axis = Y_SCALE_NORM(radius);

	return(n_arc(X_TO_NORM(x),Y_TO_NORM(y),x_axis,y_axis,angle2,angle1));
}

int move(x, y)
int x,y;
{
	return(n_movepen(X_TO_NORM(x),Y_TO_NORM(y)));
}

int cont(x, y)
int x,y;
{
	return(n_draw(X_TO_NORM(x),Y_TO_NORM(y)));
}

int point(x, y)
int x, y;
{
	return(n_point(X_TO_NORM(x),Y_TO_NORM(y)));
}

int linemod(s)
char s[];
{
	if (strncmp(s, "dotted", 6) == 0)  {
		g_style(DOTTED);
	}
	else if (strncmp(s, "dotdashed", 9) == 0)  {
		g_style(DOTDASHED);
	}
	else if (strncmp(s, "longdashed", 10) == 0)  {
		g_style(LONGDASHED);
	}
	else if (strncmp(s, "shortdashed", 11) == 0)  {
		g_style(SHORTDASHED);
	}
	else if (strncmp(s, "solid", 5) == 0)  {
		g_style(SOLID);
	}
	else  {
		g_style(SOLID);
	}
	return(0);
}

int space(x_0, y_0, x_1, y_1)
{
	/* Set constants for coordinate transformations.		*/
	/* Adjust x axis for aspect ratio so that output is square.	*/

 	xconst = (long)(x_0) * NRM_X_RANGE; 
 	xdiv = (long)((float)(x_1-x_0) / graphics.aspect_ratio);
 	yconst = y_1*NRM_Y_RANGE;
 	ydiv = y_1-y_0;
}

int closepl()
{
	return(g_finish());
}

