#ifndef lint
static char sccsid[] = "@(#) c_cursor.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Move the graphics cursor as if it were a text cursor.  The cursor	*/
/* is positioned such that a cell character may be drawn at the		*/
/* specified character row and column.					*/
/* This routine uses bit mapped character cell fonts.			*/
/* The character will be drawn such that the current graphics cursor	*/
/* denotes the upper left corner of the character cell.			*/

/* Columns and rows are numbered 1 through N, not 0 through N !!!!	*/

#include "config.h"
#include "bitmaps.h"
#include "graphics.h"

extern struct GL_graphics graphics;
extern int n_movepen();

int c_cursor(row, col)
int row, col;
{
	long xval, yval;

	/* Check valid range for this screen type.			*/
	if (col <= 0 || col > graphics.cellfont.chars_per_line) return(1);
	if (row <= 0 || row > graphics.cellfont.lines_per_screen) return(1);

	/* Move the graphics cursor.					*/

	/* Calculate size of pixel, and move cursor accordingly.  The	*/
	/* calculations are rearranged for computational accuracy, and	*/
	/* the results rounded up to put us on the correct pixel.	*/

	xval = NRM_X_RANGE * X_CELL_BITS * (col-1) / graphics.x_extent;
	xval++;	/* Round up.	*/

	yval = NRM_Y_RANGE * Y_CELL_BITS * (row-1) / graphics.y_extent;
	yval++;

	if (n_movepen((int)xval, (int)yval)) return(1);

	return(0);
}
