/*	@(#) bitmaps.h 5.1 89/02/20	*/
/*
 *	Copyright (c) David T. Lewis 1987, 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* IBM/Epson printer parameters			*/
/* Number of print pixel columns across the page. */
#define PRINTDENSITY 960
/* Number of 8 pixel print rows down the page (times 3 for full page). */
#define PRINTLINES 30

/* HP Laserjet+ printer parameters			*/
/* Number of bytes (8 pixels per byte) across the page. */
#define LJ_BYTES_PER_LINE 140
/* Number of 1 pixel print rows down the page (times 3 for full page). */
#define LJ_LINES 460
/* Define this so we don't need to rely on the sizeof() operator, which	*/
/* returns an integer value.  This could be trouble for 16 bit integer	*/
/* machines.  The sizeof(LJ_BUF_TYPE) is 140 * 460 = 64400.		*/
#define LJ_BUF_SIZE 64400

/*
 *	Define the structure for CGA video memory.
 */
typedef struct CGAMEM {
	char page1[100][80];
	char filler[192];
	char page2[100][80];
} CGA_BUF_TYPE;

/*
 *	Define the structure for EGA video memory.
 */
typedef struct EGAMEM {
	char mem[350][80];
} EGA_BUF_TYPE;

/*
 *	Define the structure for Hercules video memory.
 */
typedef struct HERCMEM {
	char page1[87][90];
	char filler1[362];
	char page2[87][90];
	char filler2[362];
	char page3[87][90];
	char filler3[362];
	char page4[87][90];
} HERC_BUF_TYPE;

/*
 *	Define the structure for a memory buffer for IBM printer bit map
 *	image.  The horizontal resolution may be either 960 bits, or 480
 *	bits (in which case only part of the 960 characters is used in each
 *	line of the buffer).  The buffer is divided into multiple pages so 
 *	that it can fit into two memory segments of < 64K each.  That is, 
 *	three of these structures must be declared to make a complete print
 *	buffer for 90 * 960 byte printing.
 */
typedef struct IBM_PR_BUF {
		char buf[PRINTLINES][PRINTDENSITY];
} PR_BUF_TYPE;	/* Three of these required! */

typedef struct LJ_PR_BUF {
		char buf[LJ_LINES][LJ_BYTES_PER_LINE];
} LJ_BUF_TYPE;	/* Three of these required! */

