#ifndef lint
static char sccsid[] = "@(#) xform.c 5.1 89/02/20";
#endif

/*
 *	Copyright (c) David T. Lewis 1988
 *	All rights reserved.
 *
 *	Permission is granted to use this for any personal noncommercial use.
 *	You may not distribute source or executable code for profit, nor
 *	may you distribute it with a commercial product without the written
 *	consent of the author.  Please send modifications to the author for
 *	inclusion in updates to the program.  Thanks.
 */

/* Various geometric transformations.					*/

#include "config.h"
#if MIX_C
#else
#include <math.h>
#endif /* MIX_C */
#include "bitmaps.h"
#include "graphics.h"

extern struct GL_graphics graphics;
extern long longsin(), longcos();

/* I_rot_2d_s rotates a point about the origin in two dimensions.	*/
/* It operates on integer values, and is used used for text rotations	*/
/* in normalized 2-D coordinate space.					*/
/* Since this is intended for text, the y values will be scaled		*/
/* according to the value of graphics.aspect_ratio.			*/
/* Note that in this coordinate system, the angle is "backwards",	*/
/* since the origin is in the upper left of the screen.  Since we	*/
/* normally want a positive angle to appear counterclockwise on the	*/
/* screen, the angle parameter will normally be negated prior to	*/
/* calling this routine.						*/

int i_rot_2d_s(x, y, theta)
int *x, *y;
double theta;
{

#if NOFLOAT
	long x_temp = (long)(*x);
	long y_temp = (long)(*y);

	/* Temporary variable is used to force explicit order of	*/
	/* integer calculations.  This probably isn't really needed	*/
	/* with most compilers, but better to be safe than sorry.	*/

	long ltemp;

	/* Scale the (floating point) aspect ratio up to a reasonable	*/
	/* integer value.						*/

	long lratio = (long)(graphics.aspect_ratio * 16.0);

	/* Pre-calculate the sin and cos values (save calls to trig	*/
	/* routines.)							*/

	long lsinval = longsin(theta);
	long lcosval = longcos(theta);

	ltemp = y_temp * lsinval;
	ltemp /= 16;	/* Scale down first to avoid overflow.		*/
	ltemp *= lratio;

	*x = (int)((x_temp * lcosval - ltemp) / TRIG_SCALE);

	ltemp = x_temp * lsinval;
	ltemp /= lratio;
	ltemp *= 16;	/* Scale it back.	*/

	*y = (int)((ltemp + y_temp * lcosval) / TRIG_SCALE);

#else
	double x_temp = (double)(*x);
	double y_temp = (double)(*y);

	/* Pre-calculate the sin and cos values (save calls to trig	*/
	/* routines.)							*/

	double sinval = sin(theta);
	double cosval = cos(theta);

	*x = (int)(x_temp * cosval
		- y_temp * sinval * graphics.aspect_ratio);
	*y = (int)(x_temp * sinval / graphics.aspect_ratio
		+ y_temp * cosval);

#endif /* NOFLOAT */

	return(0);
}

/* I_rot_2d rotates a point about the origin in two dimensions.	*/
/* It operates on integer values, and is used used for rotations in	*/ 
/* normalized 2-D coordinate space.					*/
/* Note that in this coordinate system, the angle is "backwards",	*/
/* since the origin is in the upper left of the screen.  Since we	*/
/* normally want a positive angle to appear counterclockwise on the	*/
/* screen, the angle parameter will normally be negated prior to	*/
/* calling this routine.						*/
/* This routine does not account for aspect ratio.			*/

int i_rot_2d(x, y, theta)
int *x, *y;
double theta;
{

#if NOFLOAT
	long x_temp = (long)(*x);
	long y_temp = (long)(*y);

	/* Pre-calculate the sin and cos values (save calls to trig	*/
	/* routines.)							*/

	long lsinval = longsin(theta);
	long lcosval = longcos(theta);

	*x = (int)((x_temp * lcosval - y_temp * lsinval)
		/TRIG_SCALE);
	*y = (int)((x_temp * lsinval + y_temp * lcosval)
		/TRIG_SCALE);
#else
	double x_temp = (double)(*x);
	double y_temp = (double)(*y);

	/* Pre-calculate the sin and cos values (save calls to trig	*/
	/* routines.)							*/

	double sinval = sin(theta);
	double cosval = cos(theta);

	*x = (int)(x_temp * cosval - y_temp * sinval);
	*y = (int)(x_temp * sinval + y_temp * cosval);
#endif /* NOFLOAT */

	return(0);
}


